package com.aote.webmeter.module.main.nb.impl.qinchuan;

import com.af.plugins.CommonTools;
import com.af.plugins.ConvertTools;
import com.af.plugins.DateTools;
import com.aote.webmeter.module.main.nb.impl.MeterTools;
import org.json.JSONObject;

import java.nio.charset.StandardCharsets;


/**
 * 周口秦川NB-IOT封装
 */
public class QinChuanNB extends MeterTools {

    private static final String hexKey = "cf5587a586f14afc826c633530955431";
    //
    //
    @Override
    public String openAccount(JSONObject jsonObject) throws Exception {
        // 上传序列
        String upload = jsonObject.get("upload").toString();

        // 下传序列
        String download = jsonObject.get("download").toString();

        // 16位表号
        String meterNumber = jsonObject.getString("meternumber");

        byte[] data = new byte[8];
        byte[] dateByte = date2bcd(DateTools.getNow("yyMMddHHmmss"),false);
        System.arraycopy(dateByte,0,data,2,6);

        int control = Integer.parseInt("10000001",2);

        return getInstruct("3002",control,Integer.parseInt(upload),Integer.parseInt(download),data,meterNumber,false);
    }

    @Override
    public String charge(JSONObject jsonObject) throws Exception {
        return null;
    }

    @Override
    public String changePrice(JSONObject jsonObject) throws Exception {
        return null;
    }


    // 同步时间主动上报下传
    public String syncDate(JSONObject jsonObject) throws Exception {
        // 上传序列
        String upload = jsonObject.get("upload").toString();

        // 下传序列
        String download = jsonObject.get("download").toString();

        // 16位表号
        String meterNumber = jsonObject.getString("meternumber");

        byte[] data = new byte[8];
        byte[] dateByte = date2bcd(DateTools.getNow("yyMMddHHmmss"),false);
        System.arraycopy(dateByte,0,data,2,6);

        // 05H 写数据
        int control =Integer.parseInt("10000101",2);

        return getInstruct("3003",control,Integer.parseInt(upload),Integer.parseInt(download),data,meterNumber,false);
    }

    @Override
    public String changeValve(JSONObject jsonObject) throws Exception {

        // 上传序列
        String upload = jsonObject.get("upload").toString();

        // 下传序列
        String download = jsonObject.get("download").toString();

        // 16位表号
        String meterNumber = jsonObject.getString("meternumber");
        byte[] data = new byte[1];
        String value = jsonObject.get("ValveState").toString();
        if(!value.equals("0")){
            data[0] = 2;
        }

        // 05H 写数据
        int control =Integer.parseInt("10000101",2);

        return getInstruct("0001",control,Integer.parseInt(upload),Integer.parseInt(download),data,meterNumber,true);
    }

    @Override
    public String syncAmount(JSONObject jsonObject) throws Exception {
        // 上传序列
        String upload = jsonObject.get("upload").toString();

        // 下传序列
        String download = jsonObject.get("download").toString();

        // 16位表号
        String meterNumber = jsonObject.getString("meternumber");

        // 剩余金额
        int amount =  CommonTools.mul(jsonObject.get("amount"),100,0).intValue();

        // 当前价格
        int price =  CommonTools.mul(jsonObject.get("price"),100,0).intValue();

        // 关阀值
        int closeAmount =  CommonTools.mul(jsonObject.get("closeAmount"),100,0).intValue();
        // 结算时气量
        int clcGas =  CommonTools.mul(jsonObject.get("clcGas"),100,0).intValue();
        // 结算时间
        String clcTimes = jsonObject.getString("clcTimes"); // yyMMddHHmmss;
        // 最后一次充值金额
        int reAmount =  CommonTools.mul(jsonObject.get("reAmount"),100,0).intValue(); //
        // 最后一次充值时间
        String reChargeDate =  jsonObject.getString("reChargeDate");; //yyMMddHHmmss;

        // 余量状态
        int amountState = Integer.parseInt(jsonObject.getString("amountState"));

        // 欠费关阀使能 0 - 1
        int canCloseValve = Integer.parseInt(jsonObject.getString("canCloseValve"));
        // 预扣使能 0 - 1
        int canSell = Integer.parseInt(jsonObject.getString("canSell"));

        byte[] data = new byte[35];
        System.arraycopy(IntToByte(amount,true),0,data,0,4);
        System.arraycopy(IntToByte(price,true),0,data,4,4);
        System.arraycopy(IntToByte(closeAmount,true),0,data,8,4);
        System.arraycopy(IntToByte(clcGas,true),0,data,12,4);
        System.arraycopy(date2bcd(clcTimes,false),0,data,16,6);
        System.arraycopy(IntToByte(reAmount,true),0,data,22,4);
        System.arraycopy(date2bcd(reChargeDate,false),0,data,26,6);
        data[32] = (byte)amountState;
        data[33] = (byte)canCloseValve;
        data[34] = (byte)canSell;

        // 05H 写数据
        int control =Integer.parseInt("10000101",2);

        return getInstruct("0001",control,Integer.parseInt(upload),Integer.parseInt(download),data,meterNumber,false);
    }

    @Override
    public String endPoint(JSONObject jsonObject) throws Exception {

        // 上传序列
        String upload = jsonObject.get("upload").toString();

        // 下传序列
        String download = jsonObject.get("download").toString();

        // 16位表号
        String meterNumber = jsonObject.getString("meternumber");

        byte[] data = new byte[8];
        byte[] dateByte = date2bcd(DateTools.getNow("yyMMddHHmmss"),false);
        System.arraycopy(dateByte,0,data,2,6);

        // 02H 数据下发
        int control =Integer.parseInt("10000010",2);

        return getInstruct("3001",control,Integer.parseInt(upload),Integer.parseInt(download),data,meterNumber,false);

    }

    /**
     *  读取随机数
     * @param jsonObject
     * @return
     * @throws Exception
     */
    @Override
    public String syncParam(JSONObject jsonObject) throws Exception {
        return null;
    }


    public JSONObject encode(String data) throws Exception {
        byte[] code = ConvertTools.hexStrToByte(data);
        return encode(code);
    }

    public JSONObject encode(byte[] code) throws Exception {
        JSONObject jsonObject = new JSONObject();

        if((code[0] & 0xFF) != 0x68 && (code[code.length-1] & 0xFF) != 0x16){
            jsonObject.put("isSuccess", false);
            jsonObject.put("errCode",1);
            jsonObject.put("errMsg","报文格式有误");
            return jsonObject;
        }

        String midcrs = toHexString(shortToByte(CRC16(code, 5, code.length-3),true),0,2,false);
        String mid = toHexString(code, code.length - 3, 2,true);
        if (!midcrs.equals(mid)) {
            jsonObject.put("isSuccess", false);
            jsonObject.put("errCode", 2);
            jsonObject.put("errorMsg", "数据校验码错误");
            return jsonObject;
        }

        int length = Integer.parseInt(toHexString(code,3,2,true),16);
        int upload = Integer.parseInt(toHexString(code,13,4,true),16);
        jsonObject.put("upload",upload);
        int download = Integer.parseInt(toHexString(code,17,4,true),16);
        jsonObject.put("download",download);
        String mdmCode = toHexString(code,22,2,false);
        jsonObject.put("mdmCode",mdmCode);
        String meternumber = toHexString(code, 5, 8, false);
        jsonObject.put("meternumber", meternumber);

        byte[] data = new byte[length - 27];
        System.arraycopy(code,24,data,0,length-27);

        switch (mdmCode){
            case "2010":
            case "000E":
            case "0001": {
                boolean success = data[0] == 0x00 && data[1] == 0x00;
                jsonObject.put("success", success);
                break;
            }
            case "3002": {
                //表上时间
                String meterDate = toHexString(data, 1, 6, false);
                jsonObject.put("meterDate", meterDate);

                String IMEI = new String(data, 38, 15,StandardCharsets.UTF_8);
                jsonObject.put("IMEI", IMEI);

                break;
            }
            case "3003": {
                //表上时间
                String meterDate = toHexString(data, 1, 6, false);
                jsonObject.put("meterDate", meterDate);
                break;
            }
            case "3004":{
                byte[] resultDate = decrypt_by_aes(data,ConvertTools.hexStrToByte(hexKey));
                jsonObject.put("updateType",resultDate[138]);
                double jval = CommonTools.div(Integer.parseInt(toHexString(resultDate,139,4,true),16),100,2).doubleValue();
                jsonObject.put("jval",jval);
                double price = CommonTools.div(Integer.parseInt(toHexString(resultDate,143,4,true),16),100,2).doubleValue();
                jsonObject.put("price",price);
                double meterBase = CommonTools.div(Integer.parseInt(toHexString(resultDate,147,4,true),16),1000,2).doubleValue();
                jsonObject.put("meterBase",meterBase);
                break;
            }
        }

        jsonObject.put("isSuccess", true);
        jsonObject.put("errCode", 0);
        jsonObject.put("errorMsg", "解析成功");

        return jsonObject;
    }



    private String getInstruct(String meterCode, int control ,int upload,int download ,byte[] data ,String meterNumber, boolean hasEncode) throws Exception {
        byte[] instruct = new byte[500];
        instruct[0] = 0x68;
        instruct[1] = 0x00;
        instruct[2] = 0x16;
        System.arraycopy(ConvertTools.hexStrToByte(addZone(meterNumber,16)),0,instruct,5,8);
        System.arraycopy(IntToByte(upload,true),0,instruct,13,4);
        System.arraycopy(IntToByte(download,true),0,instruct,17,4);
        instruct[21] = (byte)control;
        System.arraycopy(ConvertTools.hexStrToByte(meterCode),0,instruct,22,2);
        int length = 0;
        byte[] encoding;

        if(data != null) {

            if (hasEncode) {
                encoding = encrypt_by_aes(data, ConvertTools.hexStrToByte(hexKey));
            } else {
                encoding = data;
            }

            System.arraycopy(encoding, 0, instruct, 24, encoding.length);

            length = encoding.length + 24;

        }else {
            length = 24 ;
        }

        System.arraycopy(shortToByte((short) (length + 3),true),0,instruct,3,2);
        short crc16 = CRC16(instruct,5,length);
        System.arraycopy(shortToByte(crc16,true),0,instruct,length,2);

        instruct[length + 2] = 0x16;
        return toHexString(instruct, 0, length+3, false);
    }

}