package com.aote.webmeter.module.main.nb.impl;

import org.json.JSONObject;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class MeterTools {

    //开户 (注册帧返回)
    public abstract String openAccount(JSONObject jsonObject) throws Exception;

    //充值
    public abstract String charge(JSONObject jsonObject)throws Exception;

    //调价
    public abstract String changePrice(JSONObject jsonObject)throws Exception;

    //开关阀
    public abstract String changeValve(JSONObject jsonObject)throws Exception;

    //同步下发
    public abstract String syncAmount(JSONObject jsonObject)throws Exception;

    //通信结束帧
    public abstract String endPoint(JSONObject jsonObject)throws Exception;

    //同步参数
    public abstract String syncParam(JSONObject jsonObject)throws Exception;

    public static short CRC16(byte[] puchMsg,  int offset , int end)
    {
        int wCRCin = 0x0000;
        int wCPoly = 0x1021;
        int wChar = 0;

        while (offset < end)
        {
            wChar = puchMsg[offset++];
            wCRCin ^= (wChar << 8);
            for(int i = 0;i < 8;i++)
            {
                if((wCRCin & 0x8000) > 0)
                    wCRCin = (wCRCin << 1) ^ wCPoly;
                else
                    wCRCin = wCRCin << 1;
            }
        }
        return (short) (wCRCin) ;
    }

    public static short calcCRC16(byte[] data, int offset, int length) {
        int wCRC = 0xffff;
        for (int k = offset; k < length; k++) {
            wCRC = (wCRC ^ (0xFF & data[k]));
            for (int i = 0; i < 8; i++) {
                if ((wCRC & 0x0001) > 0)
                    wCRC = wCRC >> 1 ^ 0xA001;
                else
                    wCRC = wCRC >> 1;
            }
        }
        wCRC = (wCRC << 8) | ((wCRC >> 8) & 0xFF);
        return (short) wCRC;
    }

    public static byte[] calc_by_aes(int mode, byte[] datas, byte[] key) {
        if (datas == null || key == null || key.length != 16) {
            return null;
        }
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(mode, keySpec);
            return cipher.doFinal(datas);
        } catch (Exception e) {
            return null;
        }
    }

    public static byte[] encrypt_by_aes(byte[] datas, byte[] key) {
        return calc_by_aes(Cipher.ENCRYPT_MODE, datas, key);
    }

    public static byte[] decrypt_by_aes(byte[] datas, byte[] key) {
        return calc_by_aes(Cipher.DECRYPT_MODE, datas, key);
    }

    public static byte[] shortToByte(short x,boolean reverse) {
        byte[] ret = new byte[2];
        if(reverse){
            ret[1] = (byte) ((x >> 8) & 0xff);
            ret[0] = (byte) (x & 0xff);
        }else {
            ret[0] = (byte) ((x >> 8) & 0xff);
            ret[1] = (byte) (x & 0xff);
        }
        return ret;
    }

    public static byte[] IntToByte(int x,boolean reverse) {
        byte[] ret = new byte[4];

        if(reverse){
            ret[3] = (byte) ((x >> 24) & 0xff);
            ret[2] = (byte) ((x >> 16) & 0xff);
            ret[1] = (byte) ((x >> 8) & 0xff);
            ret[0] = (byte) (x & 0xff);
        }else {
            ret[0] = (byte) ((x >> 24) & 0xff);
            ret[1] = (byte) ((x >> 16) & 0xff);
            ret[2] = (byte) ((x >> 8) & 0xff);
            ret[3] = (byte) (x & 0xff);
        }

        return ret;
    }

    private final static char[] HEX_DIGITS = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };


    public static String toHexString(byte[] array, int offset, int length,boolean reverse)
    {
        char[] buf = new char[length * 2];
        int bufIndex = 0;
        if(reverse) {
            for (int i = offset+length-1; i >= offset; i--) {
                byte b = array[i];
                buf[bufIndex++] = HEX_DIGITS[(b >>> 4) & 0x0F];
                buf[bufIndex++] = HEX_DIGITS[b & 0x0F];
            }
        }else {
            for (int i = offset; i < offset + length; i++) {
                byte b = array[i];
                buf[bufIndex++] = HEX_DIGITS[(b >>> 4) & 0x0F];
                buf[bufIndex++] = HEX_DIGITS[b & 0x0F];
            }

        }
        return new String(buf);
    }

    public static byte[] HexToBytes(String array, boolean reverse)
    {
        char[] hexData = array.toCharArray();
        int len = hexData.length;
        byte[] out = new byte[len >> 1];
        if(reverse) {
            for (int i = hexData.length/2-1, j = 0; j < len -1; i--) {
                int f = toDigit(hexData[j], j) << 4;
                j++;
                f = f | toDigit(hexData[j], j);
                j++;
                out[i] = (byte) (f & 0xFF);
            }
        }else {
            for (int i = 0, j = 0; j < len -1; i++) {
                int f = toDigit(hexData[j], j) << 4;
                j++;
                f = f | toDigit(hexData[j], j);
                j++;
                out[i] = (byte) (f & 0xFF);
            }
        }
        return out;
    }


    public static String toBinArrayString( int length , boolean reverse)
    {
       StringBuilder BinString = new StringBuilder(Integer.toBinaryString(length));
       while (BinString.length() < 36){
           BinString.insert(0, "0");
       }
       if(reverse){
           BinString.reverse();
       }
       return BinString.toString();
    }

    public static byte[] HMACSHA256(byte[] data, byte[] key) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(key, "HmacSHA256"));
        return mac.doFinal(data);
    }

    public static byte[] date2bcd(String bcdtime, boolean reverse){
        int j = bcdtime.length() / 2;
        byte[] bytes = new byte[j];
        if(reverse) {
            for (int i = 0; i < j; i++) {
                bytes[j - i -1] = Byte.parseByte(bcdtime.substring(i * 2, (i + 1) * 2),16);
            }
        }else {
            for (int i = 0; i < j; i++) {
                bytes[i] = Byte.parseByte(bcdtime.substring(i * 2, (i + 1) * 2),16);
            }
        }
        return bytes;
    }


    public static byte[] Int2bcd(int bcd, boolean reverse) throws Exception{
        boolean flag = false;
        if(bcd < 0){
            flag = true;
            bcd = -bcd;
        }
        String bcdstr = String.valueOf(bcd);
        if(bcdstr.length() > 7){
           throw new Exception("超出可转换范围");
        }
        bcdstr = addZone(bcdstr,7);
        if(flag){
            bcdstr = "1" + bcdstr;
        }else {
            bcdstr = "0" + bcdstr;
        }
        byte[] bytes = new byte[4];

        if(reverse){
            for (int i = 3; i >= 0; i--) {
                bytes[i] = Byte.parseByte(bcdstr.substring(i*2,(i+1)*2),16);
            }
        }
        else {
            for (int i = 0; i < 4; i++) {
                bytes[i] = Byte.parseByte(bcdstr.substring(i*2,(i+1)*2),16);
            }
        }
        return bytes;
    }

    protected static String addZone(String str, int length) {

        StringBuilder strBuilder = new StringBuilder(str);
        while (strBuilder.length()<length) {
            strBuilder.insert(0, "0");
        }
        str = strBuilder.toString();
        return str;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

}
