package com.aote.webmeter.module.main.luomeitetcp;

import com.af.plugins.CommonTools;
import com.af.plugins.ConvertTools;
import com.af.plugins.DateTools;
import org.json.JSONObject;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

/**
 * TCP/UDP罗美特表对接工具
 */
public class LuoMeiTeTools {

    /**
     * 表具上报注册包返回
     *
     * @param meternumber 表号
     * @param instructId  10位ID流水号
     * @return
     */
    public String OpenAccount(String meternumber, String instructId) throws Exception {
        byte[] instruct = new byte[9];
        return getInstruct("3001", meternumber, instructId, instruct, 1, false);
    }

    /**
     * 表具结束包
     *
     * @param meternumber 表号
     * @param instructId  10位ID流水号
     * @param time        下发时间 yyMMddHHmm
     * @return
     */
    public String EndInstruct(String meternumber, String instructId, String time) throws Exception {
        byte[] instruct = new byte[12];
        instruct[7] = (byte) Integer.parseInt(time.substring(0, 2));
        instruct[8] = (byte) Integer.parseInt(time.substring(2, 4));
        instruct[9] = (byte) Integer.parseInt(time.substring(4, 6));
        instruct[10] = (byte) Integer.parseInt(time.substring(6, 8));
        instruct[11] = (byte) Integer.parseInt(time.substring(8, 10));
        return getInstruct("3002", meternumber, instructId, instruct, 0, false);
    }

    /***
     *  主动上报返回
     * @param meternumber 表号
     * @param instructId 10位ID流水号
     * @param mdmCode 功能码
     * @return
     * @throws Exception
     */
    public String response(String meternumber, String instructId,String mdmCode) throws Exception{
        byte[] instruct = new byte[14];
        System.arraycopy(new byte[2],0,instruct,7,2);
        return getInstruct(mdmCode, meternumber, instructId, instruct, 1, false);
    }

    /**
     * 调价
     *
     * @param meternumber 表号
     * @param instructId  10位ID流水号
     * @param params      需要的调价参数 ｛"price1":"","price2":"","price3":"","amount1":"","amount2":"","priceVersion":"","priceStartDate":"","priceCycle":"","priceType":""｝
     * @return
     */
    public String ChargePrice(String meternumber, String instructId, JSONObject params) throws Exception {

        byte[] instruct = new byte[57];
        short priceVersion = Short.parseShort((String) params.get("priceVersion"));
        System.arraycopy(shortToByte(priceVersion), 0, instruct, 7, 2);
        String priceStartDate = params.getString("priceStartDate");
        instruct[9] = (byte) Integer.parseInt((String) params.get("priceCycle"));
        instruct[10] = (byte) Integer.parseInt(priceStartDate.substring(0, 2));
        instruct[11] = (byte) Integer.parseInt(priceStartDate.substring(2, 4));
        instruct[12] = (byte) Integer.parseInt(priceStartDate.substring(4, 6));
        System.arraycopy(instruct, 10, instruct, 13, 3);
        String price1 = CommonTools.mul(params.get("price1"),10000,0).toString() ;
        System.arraycopy(IntToByte(Integer.parseInt(price1)),0,instruct,16,4);
        String price2 = CommonTools.mul(params.get("price2"),10000,0).toString() ;
        System.arraycopy(IntToByte(Integer.parseInt(price2)),0,instruct,20,4);
        String price3 = CommonTools.mul(params.get("price3"),10000,0).toString() ;
        System.arraycopy(IntToByte(Integer.parseInt(price3)),0,instruct,24,4);
        System.arraycopy(IntToByte(Integer.parseInt(price3)),0,instruct,28,4);
        System.arraycopy(IntToByte(Integer.parseInt(price3)),0,instruct,32,4);
        String GasValue1 = (String) params.get("amount1");
        String GasValue2 = (String) params.get("amount2");
        String GasValue3 = "999999";
        System.arraycopy(IntToByte(Integer.parseInt(GasValue1)),0,instruct,36,4);
        System.arraycopy(IntToByte(Integer.parseInt(GasValue2)),0,instruct,40,4);
        System.arraycopy(IntToByte(Integer.parseInt(GasValue3)),0,instruct,44,4);
        System.arraycopy(IntToByte(Integer.parseInt(GasValue3)),0,instruct,48,4);

        return getInstruct("3071", meternumber, instructId, instruct, 0, true);
    }

    public String ChargePrice(JSONObject content) throws Exception {
        String meternumber = content.getString("meterNumber");
        String instructId = content.getString("instructId");
        JSONObject params = new JSONObject();
        params.put("price1",content.getString("price1"));
        params.put("price2",content.getString("price2"));
        params.put("price3",content.getString("price3"));
        params.put("amount1",content.getString("amount1"));
        params.put("amount2",content.getString("amount2"));
        params.put("priceVersion",content.getString("priceVersion"));
        params.put("priceStartDate",content.getString("priceStartDate"));
        params.put("priceStartDate",content.getString("priceStartDate"));
        params.put("priceCycle",content.getString("priceCycle"));
        params.put("priceType",content.getString("priceType"));
        return ChargePrice(meternumber,instructId,params);
    }

    /**
     * 强制开阀
     *
     * @param meternumber
     * @param instructId
     * @return
     */
    public String OpenValve(String meternumber, String instructId) throws Exception {
        byte[] instruct = new byte[7];
        return getInstruct("3051",meternumber,instructId,instruct,0,false);
    }

    /**
     * 强制关阀
     *
     * @param meternumber
     * @param instructId
     * @return
     */
    public String CloseValve(String meternumber, String instructId) throws Exception{
        byte[] instruct = new byte[7];
        return getInstruct("3052",meternumber,instructId,instruct,0,false);
    }

    /**
     * 取消强制
     *
     * @param meternumber
     * @param instructId
     * @return
     */
    public String ClearMandatory(String meternumber, String instructId) throws Exception{
        byte[] instruct = new byte[7];

        return getInstruct("3053",meternumber,instructId,instruct,0,false);
    }

    /** 充值
     * @param meternumber 表号
     * @param instructId    序号id(10位)
     * @param amount  充值量
     * @param type   0 ： 气量  1：金额
     * @param sellId 流水号(最大8位)
     * @param cs 充值次数
     * @param totalAmount 充值总量
     * @return
     */
    public String Charge(String meternumber, String instructId, double amount, int type, String sellId,short cs , double totalAmount)  throws  Exception{
        byte[] instruct = new byte[28];
        System.arraycopy(shortToByte(cs), 0, instruct, 7, 2);
        String sellsid = "FC" + addZone(sellId,8);
        System.arraycopy(ConvertTools.hexStrToByte(sellsid),0,instruct,9,5);
        boolean flag = false;
        if(amount < 0){
            amount = -amount;
            flag = true;
        }

        String[] amounts = String.format("%.2f",amount).split("\\.");
        System.arraycopy(IntToByte(Integer.parseInt(amounts[0])),0,instruct,14,4);
        instruct[18] = (byte) Integer.parseInt(amounts[1]);
        if(flag){
            String amountA = getBinaryStrFromByte(instruct[14]);
            amountA = "1" + amountA.substring(1);
            instruct[14] = (byte)Integer.parseInt(amountA,2);
        }
        String[] totalAmounts = String.format("%.2f",totalAmount).split("\\.");
        System.arraycopy(IntToByte(Integer.parseInt(totalAmounts[0])),0,instruct,19,4);
        instruct[23] = (byte) Integer.parseInt(totalAmounts[1]);
        String mdmCode = "";
        if(type == 0){
            mdmCode = "3073";
        } else if(type == 1){
            mdmCode = "3074";
        } else {
            return null;
        }
        return getInstruct(mdmCode,meternumber,instructId,instruct,0,true);
    }

    public String Charge(JSONObject content) throws Exception {
        String meternumber = content.getString("meterNumber");
        String instructId = content.getString("instructId");
        double amount = content.getDouble("amount");
        int type = content.getInt("type");
        String sellId = content.getString("sellId");
        short cs = (short) content.getInt("cs");
        double totalAmount = content.getDouble("totalAmount");
        return Charge(meternumber,instructId,amount,type,sellId,cs,totalAmount);
    }

    /**
     *  气量余量同步
     * @param meternumber
     * @param instructId
     * @param params
     * @return
     */
    public String SyncAmount(String meternumber, String instructId, JSONObject params) throws Exception {

        String totalAmount = (String) params.get("totalAmount");
        String amount = (String)params.get("amount");
        String useAmount = (String) params.get("useAmount");
        String meterBase = (String) params.get("meterBase");
        String syncDate = (String) params.get("syncDate");
        String cycleStartBase = (String) params.get("cycleStartBase");
        String cycleStartDate = (String) params.get("cycleStartDate");

        byte[] instruct = new byte[68];
        byte[] meter = ConvertTools.hexStrToByte(addZone(meternumber,14));
        System.arraycopy(meter,0,instruct,0,7);

        String[] totalAmounts = String.format("%.3f",Double.parseDouble(totalAmount)).split("\\.");
        String[] amounts = String.format("%.3f",Double.parseDouble(amount)).split("\\.");
        String[] useAmounts = String.format("%.3f",Double.parseDouble(useAmount)).split("\\.");
        String[] meterBases = String.format("%.1f",Double.parseDouble(meterBase)).split("\\.");
        String[] cycleStartBases = String.format("%.1f",Double.parseDouble(cycleStartBase)).split("\\.");

        System.arraycopy(IntToByte(Integer.parseInt(totalAmounts[0])),0,instruct,7,4);
        System.arraycopy(shortToByte(Short.parseShort(totalAmounts[1])),0,instruct,11,2);
        System.arraycopy(IntToByte(Integer.parseInt(useAmounts[0])),0,instruct,13,4);
        System.arraycopy(shortToByte(Short.parseShort(useAmounts[1])),0,instruct,17,2);
        System.arraycopy(IntToByte(Integer.parseInt(amounts[0])),0,instruct,19,4);
        System.arraycopy(shortToByte(Short.parseShort(amounts[1])),0,instruct,23,2);

        System.arraycopy(IntToByte(Integer.parseInt(meterBases[0])),1,instruct,25,3);
        instruct[28] = (byte) Integer.parseInt(meterBases[1]);

        System.arraycopy(ConvertTools.hexStrToByte(syncDate),0,instruct,29,6);
        System.arraycopy(IntToByte(Integer.parseInt(cycleStartBases[0])),1,instruct,35,3);
        instruct[38] = (byte) Integer.parseInt(cycleStartBases[1]);

        System.arraycopy(ConvertTools.hexStrToByte(cycleStartDate),0,instruct,39,6);
        System.arraycopy(instruct,19,instruct,45,16);

        return getInstruct("3075",meternumber,instructId,instruct,0,true);

    }



    public String getBinaryStrFromByte(byte b){
        StringBuilder result = new StringBuilder();
        byte a = b; ;
        for (int i = 0; i < 8; i++){
            byte c=a;
            a=(byte)(a>>1);//每移一位如同将10进制数除以2并去掉余数。
            a=(byte)(a<<1);
            if(a==c){
                result.insert(0, "0");
            }else{
                result.insert(0, "1");
            }
            a=(byte)(a>>1);
        }
        return result.toString();
    }

    /***
     * 解码
     * @param code
     * @return
     */
    public JSONObject Encode(String code)  throws  Exception {
        JSONObject jsonObject = new JSONObject();
        if (code.length() % 2 != 0) {
            jsonObject.put("isSuccess", false);
            jsonObject.put("errorMsg", "传入数据错误");
            return jsonObject;
        }

        byte[] result = ConvertTools.hexStrToByte(code);
        if (result[0] != 0x68) {
            jsonObject.put("isSuccess", false);
            jsonObject.put("errorMsg", "数据起始符错误");
            return jsonObject;
        }

        if (result[result.length - 1] != 0x16) {
            jsonObject.put("isSuccess", false);
            jsonObject.put("errorMsg", "数据结束码错误");
            return jsonObject;
        }

        if (result.length == 4 && result[1] == 0x30 && result[2] == 0x03) {
            jsonObject.put("isSuccess", true);
            jsonObject.put("mdmCode", "3003");
            return jsonObject;
        }

        byte[] midByte = new byte[result.length-5];

//        System.arraycopy(result,0,midByte,0,21);
//        System.arraycopy(result,23,midByte,0,result.length-28);

        String midCrc = toHexString(shortToByte(calcCRC16(result, 0, result.length-3)),0,2,true);
        String midCrcw = toHexString(result, result.length - 3, 2);

        if (!midCrc.equals(midCrcw)) {
            jsonObject.put("isSuccess", false);
            jsonObject.put("errorMsg", "数据校验码错误");
            return jsonObject;
        }

        String mdmCode = toHexString(result, 3, 2);
        int length = Integer.parseInt(toHexString(result, 1, 2), 16);
        try {
            switch (mdmCode) {

                case "3001":

                    // SIM卡号
                    jsonObject.put("SIM", toHexString(result, 30, 10));
                    // IMEI号
                    jsonObject.put("IMEI", toHexString(result, 32, 8));
                    // 注册包
                    jsonObject.put("cmdname", "首帧上报");
                    break;

                case "3041": {
                    // 信号强度
                    jsonObject.put("", toHexString(result, 30, 1));
                    // 电源类型
                    jsonObject.put("", result[21]);
                    // 电池电量1
                    jsonObject.put("", result[32]);
                    // 是否为最后一帧
                    jsonObject.put("", result[33]);
                    // 帧序号
                    jsonObject.put("", Short.parseShort(toHexString(result, 34, 2), 16));
                    // 抄表时间
                    jsonObject.put("", getDate(result, 38, 3) + getDate(result, 41, 2));
                    // 累计总量
                    jsonObject.put("meterBase", Integer.parseInt(toHexString(result, 47, 4), 16));
                    // 抄表推送
                    jsonObject.put("cmdname", "抄表上报");
                    // 温度
                    String tempArray1 = getBinaryStrFromByte(result[55]);
                    String tempArray2 = getBinaryStrFromByte(result[56]);
                    boolean flag = false;
                    if (tempArray1.charAt(1) == '1') {
                        flag = true;
                        tempArray1 = "0" + tempArray1.substring(1);
                    }
                    double temperature = CommonTools.div(Short.parseShort(tempArray1 + tempArray2, 2), 10, 1).doubleValue();
                    if (flag) {
                        temperature = 0 - temperature;
                    }
                    jsonObject.put("temperature", temperature);
                    // 压力
                    double pressure = CommonTools.div(Integer.parseInt(toHexString(result, 57, 2), 16), 10, 1).doubleValue();
                    jsonObject.put("pressure", pressure);

                    // 阀门状态 00普开，01普关，02异常,04开阀中,05关阀中，06强开，07强关
                    jsonObject.put("valve", result[59]);

                    break;
                }
                case "3042":
                case "3043": {
                    // 信号强度
                    jsonObject.put("", toHexString(result, 30, 1));
                    // 电源类型
                    jsonObject.put("", result[31]);
                    // 电池电量1
                    jsonObject.put("", result[32]);

                    // 累计充值次数
                    jsonObject.put("times", Short.parseShort(toHexString(result, 33, 2), 16));

                    // 累计充值量
                    jsonObject.put("totalAmount", Integer.parseInt(toHexString(result, 35, 4), 16));

                    // 是否为最后一帧
                    jsonObject.put("", result[37]);
                    // 帧序号
                    jsonObject.put("", Short.parseShort(toHexString(result, 40, 2), 16));
                    // 抄表时间
                    jsonObject.put("", getDate(result, 42, 3) + getDate(result, 45, 2));
                    // 累计总量
                    jsonObject.put("meterBase", Integer.parseInt(toHexString(result, 53, 4), 16));
                    // 抄表推送
                    jsonObject.put("cmdname", "抄表上报");
                    // 温度
                    String tempArray1 = getBinaryStrFromByte(result[61]);
                    String tempArray2 = getBinaryStrFromByte(result[62]);
                    boolean flag = false;
                    if (tempArray1.charAt(0) == '1') {
                        flag = true;
                        tempArray1 = "0" + tempArray1.substring(1);
                    }
                    double temperature = CommonTools.div(Short.parseShort(tempArray1 + tempArray2, 2), 10, 1).doubleValue();
                    if (flag) {
                        temperature = 0 - temperature;
                    }
                    jsonObject.put("temperature", temperature);
                    // 压力
                    double pressure = CommonTools.div(Integer.parseInt(toHexString(result, 63, 2), 16), 10, 1).doubleValue();
                    jsonObject.put("pressure", pressure);

                    // 阀门状态 00普开，01普关，02异常,04开阀中,05关阀中，06强开，07强关
                    jsonObject.put("valve", result[65]);

                    // 剩余量
                    String gasValue = getBinaryStrFromByte(result[73]);
                    if (gasValue.charAt(0) == '1') {
                        flag = true;
                        gasValue = "0" + gasValue.substring(1);
                        result[73] = Byte.parseByte(gasValue, 2);
                    }

                    int lastAmount = Integer.parseInt(toHexString(result, 73, 4), 16);
                    if (flag) {
                        lastAmount = -lastAmount;
                    }
                    jsonObject.put("lastAmount", lastAmount);

                    break;
                }
                case "3071":
                case "3073":
                case "3051":
                case "3052":
                case "3053":
                case "3074": {
                    boolean success = false;
                    if (result[30] == 0x00 && result[31] == 0x00) {
                        success = true;
                    }
                    jsonObject.put("success", success);
                    jsonObject.put("cmdname", "指令执行结果");
                    break;
                }
                case "3061" :{

                    break;
                }
            }
        } catch (Exception e) {
            jsonObject.put("isSuccess", false);
            jsonObject.put("errorMsg", "数据解析错误");
            return jsonObject;
        }
        // 表具编号
        jsonObject.put("meternumber", toHexString(result, 23, 7));
        jsonObject.put("instructId", toHexString(result, 14, 7).substring(4));
        jsonObject.put("isSuccess", true);
        jsonObject.put("mdmCode", mdmCode);

        return jsonObject;
    }

    private String getInstruct(String meterCode, String meternumber, String sellId, byte[] data, int isRequest, boolean isEncode) throws Exception {
        byte[] instruct = new byte[200];
        int length = data.length;
        instruct[0] = 0x68;

        System.arraycopy(shortToByte((short)(data.length + 26)),0,instruct,1,2);

        System.arraycopy(ConvertTools.hexStrToByte(meterCode), 0, instruct, 3, 2);
        instruct[5] = 0x00;
        instruct[6] = (byte) isRequest;
        byte[] meter = ConvertTools.hexStrToByte(addZone(meternumber, 14));
        System.arraycopy(meter, 0, instruct, 7, 7);
        System.arraycopy(meter, 0, data, 0, 7);
        String date = DateTools.getNow("yyMM");
        instruct[14] = (byte)Integer.parseInt(date.substring(0,2));
        instruct[15] = (byte)Integer.parseInt(date.substring(2,4));
        System.arraycopy(ConvertTools.hexStrToByte(addZone(sellId, 10)), 0, instruct, 16, 5);
        byte[] lengths = shortToByte((short) length);
        instruct[21] = lengths[0];
        instruct[22] = lengths[1];

        if (isEncode) {
            System.arraycopy(data, 0, instruct, 23, length - 5);
            instruct[length + 23 - 5] = 0x00;
            byte[] serKey = {meter[0], meter[1], meter[2], meter[3], meter[4], meter[5], meter[6], 0x46, 0x4c, 0x4f, 0x57, 0x4d, 0x45, 0x54, 0x45, 0x4B};
            short midCrc16 = calcCRC16(instruct, 0, 23 + length - 4);
            byte[] results = encrypt_by_aes(shortToByte(midCrc16), serKey);
            System.arraycopy(results, 0, instruct, length + 23 - 4, 4);
        } else {
            System.arraycopy(data, 0, instruct, 23, length);
        }

        byte[] crc16 = shortToByte(calcCRC16(instruct, 0, 23 + length));
        instruct[23 + length] = crc16[1];
        instruct[24 + length] = crc16[0];
        instruct[25 + length] = 0x16;

        byte[] result = new byte[length + 26];
        System.arraycopy(instruct, 0, result, 0, result.length);

        return ConvertTools.byteToHexStr(result);
    }

    private String addZone(String str, int length) {

        StringBuilder strBuilder = new StringBuilder(str);
        while (strBuilder.length()<length) {
            strBuilder.insert(0, "0");
        }
        str = strBuilder.toString();
        return str;
    }

    private static short calcCRC16(byte[] data, int offset, int length) {
        int wCRC = 0xffff;
        for (int k = offset; k < length; k++) {
            wCRC = (wCRC ^ (0xFF & data[k]));
            for (int i = 0; i < 8; i++) {
                if ((wCRC & 0x0001) > 0)
                    wCRC = wCRC >> 1 ^ 0xA001;
                else
                    wCRC = wCRC >> 1;
            }
        }
        wCRC = (wCRC << 8) | ((wCRC >> 8) & 0xFF);
        return (short) wCRC;
    }

    private static byte[] calc_by_aes(int mode, byte[] datas, byte[] key) {
        if (datas == null || key == null || key.length != 16) {
            return null;
        }
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(mode, keySpec);
            return cipher.doFinal(datas);
        } catch (Exception e) {
            return null;
        }
    }

    private static byte[] encrypt_by_aes(byte[] datas, byte[] key) {
        return calc_by_aes(Cipher.ENCRYPT_MODE, datas, key);
    }

    private static byte[] shortToByte(short x) {
        byte[] ret = new byte[2];
        ret[0] = (byte) ((x >> 8) & 0xff);
        ret[1] = (byte) (x & 0xff);
        return ret;
    }

    private static byte[] IntToByte(int x) {
        byte[] ret = new byte[4];
        ret[0] = (byte) ((x >> 24) & 0xff);
        ret[1] = (byte) ((x >> 16) & 0xff);
        ret[2] = (byte) ((x >> 8) & 0xff);
        ret[3] = (byte) (x & 0xff);
        return ret;
    }

    private final static char[] HEX_DIGITS = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

    private static String toHexString(byte[] array, int offset, int length)
    {
        char[] buf = new char[length * 2];

        int bufIndex = 0;
        for (int i = offset ; i < offset + length; i++)
        {
            byte b = array[i];
            buf[bufIndex++] = HEX_DIGITS[(b >>> 4) & 0x0F];
            buf[bufIndex++] = HEX_DIGITS[b & 0x0F];
        }

        return new String(buf);
    }

    private static String toHexString(byte[] array, int offset, int length,boolean res)
    {
        char[] buf = new char[length * 2];

        int bufIndex = 0;
        if(res) {
            for (int i = offset+length-1; i >= offset; i--) {
                byte b = array[i];
                buf[bufIndex++] = HEX_DIGITS[(b >>> 4) & 0x0F];
                buf[bufIndex++] = HEX_DIGITS[b & 0x0F];
            }
        }else {
            for (int i = offset; i < offset + length; i++) {
                byte b = array[i];
                buf[bufIndex++] = HEX_DIGITS[(b >>> 4) & 0x0F];
                buf[bufIndex++] = HEX_DIGITS[b & 0x0F];
            }

        }
        return new String(buf);
    }

    private static String getDate(byte[] array,int offset,int length) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; i++) {
            result.append(array[offset + i]);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        String code = "{\"cs\":1,\"totalAmount\":10,\"amount\":10,\"sellId\":\"1457269\",\"meterNumber\":\"00816000000001\",\"type\":0,\"instructId\":\"7627226\"}";
        JSONObject  json= new JSONObject(code);
        LuoMeiTeTools luoMeiTeTools = new LuoMeiTeTools();
        try {
            String jsonObject =  luoMeiTeTools.Charge(json);
            System.out.println(jsonObject);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
