package com.aote.webmeter.module.main.lanbaoshinewsystem;

import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

/**
 * 蓝宝石工具类
 *
 * @author 马栋梁
 */
public class Tools {

    private static final Logger logger = Logger.getLogger(Tools.class);

    public String formatDate(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date creationTime = formatter.parse(date);
            return formatter.format(creationTime);
        } catch (ParseException e) {
            e.printStackTrace();
            return date;
        }
    }

    public JSONObject sendInstruct(String url, JSONObject header, JSONObject content) {
        try {
            String instructResult = RestTools.post(url, content, header);
            JSONObject ret = JsonTools.convertToJson(instructResult);
            return ret;
        } catch (Throwable e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("State", "fail");
            jsonObject.put("Message", "接口请求发生异常");
            jsonObject.put("Data", "");
            return jsonObject;
        }
    }

    public JSONObject formatPriceDetails(JSONArray prices) {
        Double[] retPrices = new Double[5];
        Integer[] retGas = new Integer[5];
        retPrices[0] = 1.0;
        retGas[0] = 65535;
        for (int i = 0; i < prices.length(); i++) {
            retPrices[i] = prices.getJSONObject(i).getDouble("f_price");
            retGas[i] = prices.getJSONObject(i).getInt("f_gas");
        }
        for (int i = prices.length() == 0 ? 1 : prices.length(); i < retPrices.length; i++) {
            retPrices[i] = retPrices[i - 1];
            retGas[i] = retGas[i - 1];
        }
        JSONObject ret = new JSONObject();
        for (int i = 0; i < retPrices.length; i++) {
            ret.put("price" + (i + 1), retPrices[i]);
            ret.put("gas" + (i + 1), retGas[i]);
        }
        return ret;
    }

    public String getCtrlTimeout(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date creationTime = formatter.parse(date);
            Calendar c = Calendar.getInstance();
            c.setTime(creationTime);
            c.add(Calendar.DAY_OF_MONTH, 3);
            return formatter.format(c.getTime());
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }

    }

    public String genCommandId() {
        StringBuffer str = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < 10; i++) {
            str.append(random.nextInt(10));
        }
        return str.toString();
    }
}
