package com.aote.webmeter.module.main.lanbaoshinewsystem;

import com.af.plugins.RestTools;
import com.aote.webmeter.module.main.qinchuanoldsystem.Encryption;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.log4j.Logger;
import org.json.JSONObject;

/**
 * 蓝宝石系统 应用接口鉴权
 *
 * @author Mr.river
 */
public class GetTokenTools {

	private static final Logger LOGGER = Logger.getLogger(GetTokenTools.class);
	/**
	 * 超时时间值 25天
	 */
	private static final Long TOKEN_TIMEOUT_VALUE = 1000L * 60 * 60 * 24 * 25;
	/**
	 * 鉴权有效时间
	 */
	private static Long STAMP = null;
	/**
	 * 鉴权TOKEN
	 */
	private static String AOD = null;

	/**
	 * 获取TOKEN
	 *
	 * @return TOKEN值
	 */
	public static String getAuthToken() {
		String token = getToken();
		if (token != null) {
			return token;
		} else {
			return getWebAuthToken();
		}
	}

	/**
	 * 发起获取TOKEN的请求
	 *
	 * @return TOKEN信息
	 */
	private static synchronized String getWebAuthToken() {
		String token = getToken();
		if (token == null) {
			String url = WebMeterInfo.getString("authUrl");
			String loginName = WebMeterInfo.getString("loginName");
			String pwd = WebMeterInfo.getString("pwd");

			LOGGER.info(loginName + ":进行蓝宝石鉴权操作");
			String responseBody = RestTools.post(url + "?loginName=" + loginName + "&pwd=" + Encryption.MD5Encryption(pwd));
			JSONObject body = new JSONObject(responseBody);
			if ("success".equals(body.getString("State"))) {
				JSONObject data = body.getJSONObject("Data");
				AOD = data.getString("token");
				STAMP = System.currentTimeMillis();
				return AOD;
			} else {
				throw new RuntimeException("蓝宝石鉴权失败！，错误信息：" + body.getString("Message"));
			}
		}
		return token;
	}

	private static String getToken() {
		long current = System.currentTimeMillis();
		String accessToken = AOD;
		Long stampValue = STAMP;
		if (accessToken != null && stampValue != null && (current - stampValue) < TOKEN_TIMEOUT_VALUE) {
			LOGGER.info("获取现有的蓝宝石token");
			return accessToken;
		} else {
			return null;
		}
	}
}
