package com.aote.webmeter.module.main.laideudp;

import com.af.plugins.ConvertTools;
import com.protocol.BbtMakeCommand;
import org.json.JSONObject;

import java.math.BigDecimal;

/**
 * 莱德UDP表对接兼容工具
 * @author Mrriver
 */
public class LaiDeUdpTools {
    public int sellGas(Integer var0, String var1, Integer var2, BigDecimal var3, BigDecimal var5, Integer var7, Integer var8, Integer var9, String var10, String var11, String var12, String var13, String var14, String var15, String var16, StringBuilder var18){
        return BbtMakeCommand.SellGas(var0,var1,var2,var3.doubleValue(),var5.doubleValue(),var7,var8,var9,var10,var11,var12,var13,var14,var15,var16,var18);
    }

    public String sellGas2(Object id, JSONObject content){
        StringBuilder command = new StringBuilder();
        int result = BbtMakeCommand.SellGas(
                Integer.parseInt(id.toString()),
                content.getString("meterNumber"),1,content.getDouble("payValue"),content.getDouble("total"),
                content.getInt("times"),1, content.getInt("months"),content.getString("stairDate"),
                null,content.getString("jtPrice"),null,content.getString("jtGas"),null,
                content.getString("priceDate"),command);
        if(result == 0){
            return command.toString();
        } else {
            return "-1";
        }
    }

    public String setPrice(Object id, JSONObject content){
        StringBuilder command = new StringBuilder();
        int result = BbtMakeCommand.SetPrice(
                Integer.parseInt(id.toString()),
                content.getString("meterNumber"),1,content.getInt("months"),content.getString("stairDate"),
                null,content.getString("jtPrice"),null,content.getString("jtGas"),null,
                content.getString("priceDate"),command);
        if(result == 0){
            return command.toString();
        } else {
            return "-1";
        }
    }

    public String setValveControl(Object id, JSONObject content){
        StringBuilder command = new StringBuilder();
        int result;
        if(content.getInt("isOpen") == 1){
            result = BbtMakeCommand.Openvalue(Integer.parseInt(id.toString()),content.getString("meterNumber"),command);
        } else {
            result = BbtMakeCommand.CloseCommand(Integer.parseInt(id.toString()),content.getString("meterNumber"),0,command);
        }
        if(result == 0){
            return command.toString();
        } else {
            return "-1";
        }
    }

    public int reWriteJtUseGas(Integer var0, String var1, BigDecimal var2, StringBuilder var3){
        return BbtMakeCommand.ReWriteJtUseGas(var0,var1,var2.doubleValue(),var3);
    }

    public String reWriteJtUseGas2(Object id, JSONObject content){
        StringBuilder command = new StringBuilder();
        int result = BbtMakeCommand.ReWriteJtUseGas(Integer.parseInt(id.toString()),
                content.getString("meterNumber"),content.getDouble("gasNum"),command);
        if(result == 0){
            return command.toString();
        } else {
            return "-1";
        }
    }

    public String setIP(Object id, JSONObject content){
        StringBuilder command = new StringBuilder();
        int result = BbtMakeCommand.SetIpPort(Integer.parseInt(id.toString()),
                content.getString("meterNumber"),
                content.getString("ip"),content.getInt("port"),
                content.getString("ip2"),content.getInt("port2"),command);
        if(result == 0){
            return command.toString();
        } else {
            return "-1";
        }
    }

    public JSONObject resolve(String params){
        StringBuilder command = new StringBuilder();
        int result = BbtMakeCommand.Resolve(ConvertTools.replaceAll(params),command);
        if(result == 0){
            return new JSONObject(command.toString());
        } else {
            return null;
        }
    }

    public String clearZeroCmd(Object id, JSONObject content){
        StringBuilder command = new StringBuilder();
        int result = BbtMakeCommand.ClearZerocmd(Integer.parseInt(id.toString()),
                content.getString("meterNumber"),command);
        if(result == 0){
            return command.toString();
        } else {
            return "-1";
        }
    }



    public String disconnect(String imei){
        StringBuilder command = new StringBuilder();
        int result = BbtMakeCommand.Disconnect(1,imei,command);
        if(result == 0){
            return command.toString();
        } else {
            return "-1";
        }
    }

    public double getDouble(String num){
        return Double.parseDouble(num);
    }
}
