package com.aote.webmeter.module.main.laidenb.parsedata;

import org.apache.commons.lang.StringUtils;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

/***
 * �??换工具类
 *
 * @author Administrator
 *
 */
public class Util {

	//byte 与 int 的相互转换
	public static byte intToByte(int x) {
		return (byte) x;
	}

	public static int byteToInt(byte b) {
		//Java 总是把 byte 当做有符处理；我们可以通过将其和 0xFF 进行二进制与得到它的无符值
		return b & 0xFF;
	}

	/**
	 * @功能: BCD码转�??10进制�??(阿拉�??数据)
	 * @参数: BCD�??
	 * @结果: 10进制�??
	 */
	public static String bcd2Str(byte[] bytes) {
		StringBuffer temp = new StringBuffer(bytes.length * 2);
		for (int i = 0; i < bytes.length; i++) {
			temp.append((byte) ((bytes[i] & 0xf0) >>> 4));
			temp.append((byte) (bytes[i] & 0x0f));
		}
		return temp.toString();
	}

	public static byte[] StrToBCDBytes(String s) {

		if (s.length() % 2 != 0) {
			s = "0" + s;
		}
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		char[] cs = s.toCharArray();
		for (int i = 0; i < cs.length; i += 2) {
			int high = cs[i] - 48;
			int low = cs[i + 1] - 48;
			baos.write(high << 4 | low);
		}
		return baos.toByteArray();

	}

	public static String hexToAscii(String hexStr) {
		StringBuilder output = new StringBuilder();
		for (int i = 0; i < hexStr.length(); i += 2) {
			String str = hexStr.substring(i, i + 2);
			output.append((char) Integer.parseInt(str, 16));
		}
		return output.toString();
	}

	public static int convertToDecimal(String binary) {
		return Integer.valueOf(binary, 2);
	}

	public static String stringToAscii(String value) {
		StringBuffer sbu = new StringBuffer();
		char[] chars = value.toCharArray();
		for (int i = 0; i < chars.length; i++) {
			if (i != chars.length - 1) {
				sbu.append((int) chars[i]).append(",");
			} else {
				sbu.append((int) chars[i]);
			}
		}
		return sbu.toString();
	}

	public static String asciiToString(String value) {
		StringBuffer sbu = new StringBuffer();
		String[] chars = value.split(",");
		for (int i = 0; i < chars.length; i++) {
			sbu.append((char) Integer.parseInt(chars[i]));
		}
		return sbu.toString();
	}

	/***计算�??加和 超出0xff忽略不�??
	 *
	 * @param data
	 * @return
	 */
	public static String makeChecksum1(String data) {
		if (data == null || "".equals(data)) {
			return "";
		}
		int total = 0;
		int len = data.length();
		int num = 0;
		while (num < len) {
			String s = data.substring(num, num + 2);
			////System.out.println(s);
			total += Integer.parseInt(s, 16);
			num = num + 2;
		}
		/**
		 * �??256求余最大是255，即16进制的FF
		 */
		int mod = total % 256;
		String hex = Integer.toHexString(mod);
		len = hex.length();
		// 如果不�?�校验位的长度，�??0,这里用的�??两位校验
		if (len < 2) {
			hex = "0" + hex;
		}
		return hex;
	}

	public static String makeChecksum(String hexdata, int len) {
		if (hexdata == null || "".equals(hexdata)) {
			return "00";
		}
		hexdata = hexdata.replaceAll(" ", "");
		int total = 0;

		if (len % 2 != 0) {
			return "00";
		}
		int num = 0;
		while (num < len) {
			String s = hexdata.substring(num, num + 2);
			total += Integer.parseInt(s, 16);
			num = num + 2;
		}
		return hexInt(total);
	}

	private static String hexInt(int total) {
		int a = total / 256;
		int b = total % 256;
		if (a > 255) {
			return hexInt(a) + format(b);
		}
		return format(a) + format(b);
	}

	private static String format(int hex) {
		String hexa = Integer.toHexString(hex);
		int len = hexa.length();
		if (len < 2) {
			hexa = "0" + hexa;
		}
		return hexa;

	}

	@SuppressWarnings("unused")
	private static String makeCheckSum(String data, int length) {
		int dSum = 0;

		int index = 0;
		// 遍历十六进制，并计算总和
		while (index < length) {
			String s = data.substring(index, index + 2); // �??�??2位字�??
			dSum += Integer.parseInt(s, 16); // 十六进制�??成十进制 , 并�?�算十进制的总和
			index = index + 2;
		}

		int mod = dSum % 256; // �??256取余，十�??进制最大是FF，FF的十进制�??255
		String checkSumHex = Integer.toHexString(mod); // 余数�??成十�??进制
		length = checkSumHex.length();
		if (length < 2) {
			checkSumHex = "0" + checkSumHex; // 校验位不足两位的，在前面�??0
		}
		return checkSumHex;
	}

	// public static String bytesToHexString(byte[] src) {
	// 	StringBuilder stringBuilder = new StringBuilder("");
	// 	if (src == null || src.length <= 0) {
	// 		return null;
	// 	}
	// 	for (int i = 0; i < src.length; i++) {
	// 		int v = src[i] & 0xFF;
	// 		String hv = Integer.toHexString(v);
	// 		if (hv.length() < 2) {
	// 			stringBuilder.append(0);
	// 		}
	// 		stringBuilder.append(hv);
	// 	}
	// 	return stringBuilder.toString();
	// }

	public static byte[] intToByteArray(int a) {
		if (a < 0) {
			a = a + 256;
		}
		return new byte[]{
				(byte) ((a >> 24) & 0xFF),
				(byte) ((a >> 16) & 0xFF),
				(byte) ((a >> 8) & 0xFF),
				(byte) (a & 0xFF)};
	}


	public static int byteArrayToInt(byte[] bytes) {
		int value = 0;
		// 由高位到低位
		for (int i = 0; i < 4; i++) {
			int shift = (4 - 1 - i) * 8;
			value += (bytes[i] & 0x000000FF) << shift;// 往高位�??
		}
		return value;
	}

	public static int HexToInt(byte[] Hex, int Count) {
		int Result = 0;
		for (int i = 0; i < Count; i++) {
			Result = Result << 8 | Hex[i] & 0xFF;
		}
		return Result;
	}

	/// <summary>
	/// 10进制串转为BCD�??
	/// </summary>
	/// <param name="asc">10进制�?? </param>
	/// <returns>BCD�?? </returns>
	public static byte[] str2Bcd(String asc) {
		int len = asc.length();
		int mod = len % 2;

		if (mod != 0) {
			asc = "0" + asc;
			len = asc.length();
		}

		byte[] abt = new byte[len];
		if (len >= 2) {
			len = len / 2;
		}

		byte[] bbt = new byte[len];
		abt = asc.getBytes(StandardCharsets.US_ASCII);
		// abt = System.Text.Encoding.ASCII.GetBytes(asc);
		int j, k;

		for (int p = 0; p < asc.length() / 2; p++) {
			if ((abt[2 * p] >= '0') && (abt[2 * p] <= '9')) {
				j = abt[2 * p] - '0';
			} else if ((abt[2 * p] >= 'a') && (abt[2 * p] <= 'z')) {
				j = abt[2 * p] - 'a' + 0x0a;
			} else {
				j = abt[2 * p] - 'A' + 0x0a;
			}

			if ((abt[2 * p + 1] >= '0') && (abt[2 * p + 1] <= '9')) {
				k = abt[2 * p + 1] - '0';
			} else if ((abt[2 * p + 1] >= 'a') && (abt[2 * p + 1] <= 'z')) {
				k = abt[2 * p + 1] - 'a' + 0x0a;
			} else {
				k = abt[2 * p + 1] - 'A' + 0x0a;
			}

			int a = (j << 4) + k;
			byte b = (byte) a;
			bbt[p] = b;
		}
		return bbt;
	}

	public static final String bytesToHexString(byte[] bArray) {
		StringBuffer sb = new StringBuffer(bArray.length);
		String sTemp;
		for (int i = 0; i < bArray.length; i++) {
			sTemp = Integer.toHexString(0xFF & bArray[i]);
			if (sTemp.length() < 2) {
				sb.append(0);
			}
			sb.append(sTemp.toUpperCase());
		}
		return sb.toString();
	}

	public static final String byteToHexString(byte bArray) {
		StringBuffer sb = new StringBuffer(1);
		String sTemp;
		sTemp = Integer.toHexString(0xFF & bArray);
		if (sTemp.length() < 2) {
			sb.append(0);
		}
		sb.append(sTemp.toUpperCase());
		return sb.toString();
	}

	public static String str2HexStr(String str) {
		char[] chars = "0123456789ABCDEF".toCharArray();
		StringBuilder sb = new StringBuilder();
		byte[] bs = str.getBytes();
		int bit;
		for (int i = 0; i < bs.length; i++) {
			bit = (bs[i] & 0x0f0) >> 4;
			sb.append(chars[bit]);
			bit = bs[i] & 0x0f;
			sb.append(chars[bit]);
		}
		return sb.toString();
	}

	public static String Int2Hex(int integer) {
		StringBuffer buf = new StringBuffer(2);
		if ((integer & 0xff) < 0x10) {
			buf.append("0");
		}
		buf.append(Long.toString(integer & 0xff, 16));
		return buf.toString();
	}

	public static String byteArrToBinStr(byte[] b) {
		StringBuffer result = new StringBuffer();
		for (int i = 0; i < b.length; i++) {
			result.append(Long.toString(b[i] & 0xff, 2) + ",");
		}
		return result.toString().substring(0, result.length() - 1);
	}

	/**
	 * To byte array byte [ ].
	 *
	 * @param hexString the hex string
	 * @return the byte [ ]
	 */
	public static byte[] toByteArray(String hexString) {
		if (StringUtils.isEmpty(hexString)) {
			return null;
		}
		hexString = hexString.toLowerCase();
		final byte[] byteArray = new byte[hexString.length() >> 1];
		int index = 0;
		for (int i = 0; i < hexString.length(); i++) {
			if (index > hexString.length() - 1) {
				return byteArray;
			}
			byte highDit = (byte) (Character.digit(hexString.charAt(index), 16) & 0xFF);
			byte lowDit = (byte) (Character.digit(hexString.charAt(index + 1), 16) & 0xFF);
			byteArray[i] = (byte) (highDit << 4 | lowDit);
			index += 2;
		}
		return byteArray;
	}

	/**
	 * hex�ַ���תbyte����
	 *
	 * @param inHex ��ת����Hex�ַ���
	 * @return ת�����byte������
	 */
	public static byte[] hexToByteArray(String inHex) {
		int hexlen = inHex.length();
		byte[] result;
		if (hexlen % 2 == 1) {
			//����
			hexlen++;
			result = new byte[(hexlen / 2)];
			inHex = "0" + inHex;
		} else {
			//ż��
			result = new byte[(hexlen / 2)];
		}
		int j = 0;
		for (int i = 0; i < hexlen; i += 2) {
			result[j] = hexToByte(inHex.substring(i, i + 2));
			j++;
		}
		return result;
	}

	/**
	 * Hex�ַ���תbyte
	 *
	 * @param inHex ��ת����Hex�ַ���
	 * @return ת�����byte
	 */
	public static byte hexToByte(String inHex) {
		return (byte) Integer.parseInt(inHex, 16);
	}

	public static int HexStringToInt(String HexString) {
		BigInteger bi = new BigInteger(HexString, 16);
		return bi.intValue();
	}
}
