package com.aote.webmeter.module.main.laidenb.parsedata;

import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

public class Tools {


	/**
	 * 取系统当前日期
	 *
	 * @param
	 * @return 返回系统日期 yyyy-MM-dd HH:mm:ss
	 */
	public static String getNow() {
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String str = df.format(new Date());
		return str;
	}

	/**
	 * 描述： 获取当前日期
	 *
	 * @参数：null
	 * @返回值：返回系统日期 yyMMdd
	 */
	public static String getNowDT() {
		SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
		String str = df.format(new Date());
		return str;
	}

	/**
	 * 描述：获取当前日期yyyy年MM月dd日  星期
	 *
	 * @return
	 */
	public static String getNowWeek() {
		SimpleDateFormat df = new SimpleDateFormat("yyyy年MM月dd日  EEEE");
		String str = df.format(new Date());
		return str;
	}

	/**
	 * 浮点数转换成两位小数
	 *
	 * @return 返回保留两位小数的字符串
	 */
	public static String formatFloat(double db) {
		DecimalFormat df = new DecimalFormat("#.00");
		return df.format(db);
	}

	/**
	 * 描述： 根据传入的仪表序号重写recno
	 *
	 * @参数：recNo
	 * @返回值：recNo
	 */
	public static String formatRecNo(String recNo) {
		switch (recNo.length()) {
			case 1:
				recNo = "000" + recNo;
				break;
			case 2:
				recNo = "00" + recNo;
				break;
			case 3:
				recNo = "0" + recNo;
				break;
			default:
				recNo = "0001";
		}
		return recNo;
	}

	/**
	 * 获取当前时间一年前的时间
	 *
	 * @return
	 */
	public static String getLastYear() {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Calendar c = Calendar.getInstance();
		//过去一年
		c.setTime(new Date());
		c.add(Calendar.YEAR, -1);
		Date y = c.getTime();
		String year = format.format(y);
		return year;
	}

	/**
	 * 描述：返回n天前日期 格式yyyy-MM-dd
	 *
	 * @param n
	 * @return
	 */
	public static String getForNDay(int n) {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DATE, -n);
		String dayDate = new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
		return dayDate;
	}

	/**
	 * 描述：返回n天后日期 格式yyyyMMdd
	 *
	 * @param n
	 * @return
	 */
	public static String getForNRDay(int n) {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DATE, n);
		String dayDate = new SimpleDateFormat("yyyyMMdd").format(cal.getTime());
		return dayDate;
	}

	/**
	 * 描述：得到前n个月的月份字符串
	 *
	 * @param n
	 * @return
	 */
	public static String getForNMonth(int n) {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.MONTH, -n);
		String monthDate = new SimpleDateFormat("yyyy-MM").format(cal.getTime());
		return monthDate;
	}

	/**
	 * 获取n小时前的时间yyyy-MM-dd HH:mm:ss
	 *
	 * @param n
	 * @return
	 */
	public static String getForNHours(int n) {
		Calendar calendar = Calendar.getInstance();
		/* HOUR_OF_DAY 指示一天中的小时 */
		calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - n);
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return df.format(calendar.getTime());
	}

	/**
	 * 描述：用指定字符填充字符串
	 *
	 * @param id
	 * @param len
	 * @param c
	 * @return
	 */
	public static String lpad(String id, int len, char c) {
		if (!id.equals("")) {
			while (id.length() < len) {
				id = c + id;
			}
		}
		return id;
	}

	/**
	 * 将日期字符串类型转换成Integer类型 ,格式为 yyyyMMdd 例：返回20091011
	 *
	 * @param str
	 * @return
	 */
	public static Integer getIntDate(String str) {
		str = str.replace("-", "").substring(0, 8);
		Integer intDate = Integer.parseInt(str);
		return intDate;
	}

	/**
	 * 计算bdate-smdate之间的天数
	 *
	 * @param smdate
	 * @param bdate
	 * @return
	 * @throws ParseException
	 */
	public static int daysBetween(String smdate, String bdate) throws ParseException {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
		Calendar cal = Calendar.getInstance();
		cal.setTime(sdf.parse(smdate));
		long time1 = cal.getTimeInMillis();
		cal.setTime(sdf.parse(bdate));
		long time2 = cal.getTimeInMillis();
		long between_days = (time2 - time1) / (1000 * 3600 * 24);

		return Integer.parseInt(String.valueOf(between_days));
	}

	/**
	 * 描述：判断字符串是不是数字类型
	 *
	 * @param str
	 * @return
	 */
	public static boolean isNum(String str) {
		return str.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
	}

	/**
	 * 描述：获取服务器MAC地址
	 *
	 * @return
	 * @throws IOException
	 */
	public static String getMacByIp() throws IOException {
		String MacStr = "";
		InetAddress ia;
		try {
			ia = InetAddress.getLocalHost();
			byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < mac.length; i++) {
				//字节转换为整数
				int temp = mac[i] & 0xff;
				String str = Integer.toHexString(temp);
				if (str.length() == 1) {
					sb.append("0" + str);
				} else {
					sb.append(str);
				}
			}
			MacStr = sb.toString().toUpperCase();
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}

		return MacStr;
	}

	/**
	 * @return
	 * @Description 获取当前年
	 */
	public static String getCurDateY() {
		Date date = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyy");
		return format.format(date);
	}

	public static String getRandomString(int length) {
		String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		Random random = new Random();
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < length; i++) {
			int number = random.nextInt(62);
			sb.append(str.charAt(number));
		}
		return sb.toString();
	}

	/**
	 * 字符串转换成日期时间
	 *
	 * @return 返回被格式化的日期 yyyy-MM-dd HH:mm:ss
	 */
	public static Date strToDateTime(String str) {
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date date = null;
		try {
			date = df.parse(str);
		} catch (ParseException e) {
			//System.out.println(e.getMessage());
			//e.printStackTrace();
		}
		return date;
	}

	/**
	 * @return String
	 * @Description: 获取系统当前日期
	 */
	public static String getCurDate() {
		Date date = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		return format.format(date);
	}

	/**
	 * @return String
	 * @Description:获取系统当前月第一天日期
	 */
	public static String getFirstDateByCurMonth() {
		Date date = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
		return format.format(date) + "-01";
	}

	public static String getCurMonth() {
		Date date = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
		return format.format(date);
	}

	/**
	 * 获取从当前月向后推一年的日期
	 *
	 * @return
	 * @Description
	 */
	public static String getLastOneYear() {
		Date date = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		calendar.add(Calendar.YEAR, -1);
		date = calendar.getTime();
		String currentDate = format.format(date);
		return currentDate;
	}

	/**
	 * @return String
	 * @Description:当前月向前推1个月的日期 eg2016-12-06向前一月是2016-11-07
	 * @author zj
	 * @date 2016-12-6
	 */
	public static String getLastOneMonth() {
		Calendar curr = Calendar.getInstance();
		curr.set(Calendar.MONTH, curr.get(Calendar.MONTH) - 1);
		curr.set(Calendar.DAY_OF_MONTH, curr.get(Calendar.DAY_OF_MONTH) + 1);
		Date date = curr.getTime();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		return format.format(date);

	}

	/**
	 * 获取从当前月向后推一年的日期
	 *
	 * @return
	 * @Description
	 */
	public static String getLastOneYears() {
		Date date = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		calendar.add(Calendar.YEAR, -1);
		date = calendar.getTime();
		String currentDate = format.format(date);
		return currentDate;
	}


	public static String NullToEmpty(Object obj) {
		if (obj == null)
			return "";
		else
			return obj.toString();
	}

	/**
	 * 取出一个指定长度大小的随机正整数.
	 *
	 * @param length int 设定所取出随机数的长度。length小于11
	 * @return int 返回生成的随机数。
	 */
	public static int buildRandom(int length) {
		int num = 1;
		double random = Math.random();
		if (random < 0.1) {
			random = random + 0.1;
		}
		for (int i = 0; i < length; i++) {
			num = num * 10;
		}
		return (int) ((random * num));
	}


	/**
	 * 十六进制转二进制
	 *
	 * @param hex 十六进制的数据
	 * @param n   补位长度
	 */
	public static String hexToBinary(String hex, int n) {
		int decimal = Integer.parseInt(hex, 16);
		String binaryString = Integer.toBinaryString(decimal);
		while (binaryString.length() < n)
			binaryString = "0" + binaryString;
		return binaryString;
	}

	/**
	 * 十进制转二进制
	 *
	 * @param num 十进制的数据
	 * @param n   补位长度
	 */
	public static String numToBinary(int num, int n) {
		String binaryString = Integer.toBinaryString(num);
		while (binaryString.length() < n)
			binaryString = "0" + binaryString;
		return binaryString;
	}

	/**
	 * 十进制转十六进制
	 *
	 * @param n
	 * @return
	 */
	public static String Integer2HexStr(Integer n) {
		String hex = Integer.toHexString(n);
		if (hex.length() == 1) {
			hex = '0' + hex;
		}
		return hex.toUpperCase();
	}

	/**
	 * 获取当前时间 yyyyMMddHHmmss
	 *
	 * @return String
	 */
	public static String getCurrTime() {
		Date now = new Date();
		SimpleDateFormat outFormat = new SimpleDateFormat("yyyyMMddHHmmss");
		String s = outFormat.format(now);
		return s;
	}

	/**
	 * 生成交易流水号
	 *
	 * @return
	 */
	public static String getPayNo() {
		String currTime = Tools.getCurrTime();
		int strRandom = Tools.buildRandom(4);
		return currTime + strRandom;
	}

	/**
	 * 获取IP
	 *
	 * @param request
	 * @return
	 */
	public static String getIp(HttpServletRequest request) {
		String ip = request.getHeader("X-Forwarded-For");
		if (StringUtils.isNotEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)) {
			//多次反向代理后会有多个ip值，第一个ip才是真实ip
			int index = ip.indexOf(",");
			if (index != -1) {
				return ip.substring(0, index);
			} else {
				return ip;
			}
		}
		ip = request.getHeader("X-Real-IP");
		if (StringUtils.isNotEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)) {
			return ip;
		}
		return request.getRemoteAddr();
	}


	public static void main(String[] args) {
		////System.out.println(Tools.getForNHours(72));
		////System.out.println("0".getBytes().length+"12345678901234".getBytes().length+String.valueOf(1).getBytes().length);

		////System.out.println(URLEncoder.encode("0|0004|2018000001|11223344556677|1|0001|1.0"));

		//String meterDate = "20190125184200";
		////System.out.println(meterDate.substring(0, 4)+"-"+meterDate.substring(4, 6)+"-"+meterDate.substring(6, 8)+" "+meterDate.substring(8, 10)+":"+meterDate.substring(10, 12)+":"+meterDate.substring(12, 14));

		//扫码页面
		//http://www.ldgasmeter.com/redxgas_WX/easypay.html?barcode=88660010000019
		//http%3A%2F%2Fwww.ldgasmeter.com%2Fredxgas_WX%2Feasypay.html%3Fbarcode%3D88660010000019

		//扫码回调页面
		//http://www.ldgasmeter.com/redxgas_WX/zhifuchenggong.html?orderNo=1234&trade_type=212
		//http%3A%2F%2Fwww.ldgasmeter.com%2FFredxgas_WX%2Fzhifuchenggong.html%3ForderNo%3D1234

		//微信公众号授权获取openId
		//https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx57a08f34e21be3a3&redirect_uri=http%3A%2F%2Fwww.ldgasmeter.com%2Fredxgas_WX%2Feasypay.html%3Fbarcode%3D88660010000019&response_type=code&scope=snsapi_base&state=1#wechat_redirect

		////System.out.println("https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx73adc8d3f6b0617a&redirect_uri="+URLEncoder.encode("http://www.pn-iot.com/MeterMis/login.jsp")+"&response_type=code&scope=snsapi_base&state=2#wechat_redirect");
		//https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx73adc8d3f6b0617a&redirect_uri=http%3A%2F%2Fwww.pn-iot.com%2Fgzhpt%2Fpayment%2Fgzhao%2Findex.html&response_type=code&scope=snsapi_base&state=1#wechat_redirect

		//System.out.println(Tools.getNow().replace(" ", "T"));
	}


}
