package com.aote.webmeter.module.main.laidenb;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.af.plugins.CommonTools;
import com.af.plugins.DateTools;
import com.aote.webmeter.module.main.laidenb.parsedata.TranscodeUtil;
import com.aote.webmeter.module.main.laidenb.parsedata.UDPDataParse;
import com.aote.webmeter.tools.iot.SignalDeliveryTools;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LaiDeTools {

    static final Map<String,String> uploadTypeDictionary;

    static final Map<String,String> chargeResultCodeDictionary;

    static final Map<String,String> replyDictionary;

    static final Map<String,StringBuilder> flowDataCache = new HashMap<>(10);

    static {
        uploadTypeDictionary = new HashMap<>(12);
        uploadTypeDictionary.put("reportByDeathMeterTwo","死表2上报");
        uploadTypeDictionary.put("reportBySmallFlow","小流检测上报");
        uploadTypeDictionary.put("reportByKey1","按键1上报");
        uploadTypeDictionary.put("reportByLargeFlow","大流检测上报");
        uploadTypeDictionary.put("reportByTime","定时上报");
        uploadTypeDictionary.put("reportByLowPower","低电上报");
        uploadTypeDictionary.put("reportByKey2","按键2上报");
        uploadTypeDictionary.put("reportByMagneticPro","磁保护上报");
        uploadTypeDictionary.put("reportByDeathMeterOne","死表1上报");
        uploadTypeDictionary.put("reportByLostPower","掉电上报");
        uploadTypeDictionary.put("reportByReset","上电上报");
        uploadTypeDictionary.put("reportByContiueUseGas","持续用气检测上报");
        uploadTypeDictionary.put("reportByFlowException","流量异常上报");

        chargeResultCodeDictionary = new HashMap<>(12);
        chargeResultCodeDictionary.put("01","SE充值失败");
        chargeResultCodeDictionary.put("04","超出限购");
        chargeResultCodeDictionary.put("06","充值次数错误");
        chargeResultCodeDictionary.put("88","MAC错误");
        chargeResultCodeDictionary.put("84","MAC错误");
        chargeResultCodeDictionary.put("67","错误的长度");
        chargeResultCodeDictionary.put("81","文件类型不匹配");
        chargeResultCodeDictionary.put("82","权限不够");
        chargeResultCodeDictionary.put("85","增加金额溢出");
        chargeResultCodeDictionary.put("A2","文件未找到");
        chargeResultCodeDictionary.put("6E","无效的CLA");
        chargeResultCodeDictionary.put("93","应用永久锁定");
        chargeResultCodeDictionary.put("83","认证方法锁死");

        replyDictionary = new HashMap<>(7);
        replyDictionary.put("MeterReplyPriceDetail","读取价格");
        replyDictionary.put("MeterReplyGetParam","读取表具参数");
        replyDictionary.put("MeterReplyGetFlowCheck","读取流量检测参数");
        replyDictionary.put("MeterReplyWriteGetRecords","读取历史记录");
        replyDictionary.put("MeterReplyWriteGetModuleInfo","读取模组信息");
        replyDictionary.put("MeterReplyWriteGetReportIPOne","读取上报IP");
        replyDictionary.put("MeterReplyWriteGetReportTimeOne","读取上报时间");
    }

    private static final Logger LOGGER = Logger.getLogger(LaiDeTools.class);

    /**
     * 指令加密封装
     *
     * @param isSessionKey 是否已协商密钥
     * @param seUid        seUid
     * @param seKey        seKey
     * @param seTempKey    seTempKey
     * @param data         待加密/封装的指令
     * @return 加密封装后的指令
     */
    public static JSONObject getData(String isSessionKey, String seUid, String seKey, String seTempKey, String data) {
        // 加密
        if (StringUtils.isNotBlank(isSessionKey) && isSessionKey.equals("1")) {
            data = UDPDataParse.EncryptData_SE(
                    seUid,
                    seKey,
                    seTempKey,
                    "ranStr",
                    data
            );
        }
        assert data != null;
        String cmdBase64Value = TranscodeUtil
                .byteArrayToBase64Str(TranscodeUtil.hexStrToByteArray(data));
        JSONObject result = new JSONObject();
        result.put("ControlCode", cmdBase64Value);
        result.put("DataLen", data.length() / 2);
        return result;
    }
    public static JSONObject getData(String data) {
        String cmdBase64Value = TranscodeUtil
                .byteArrayToBase64Str(TranscodeUtil.hexStrToByteArray(data));
        JSONObject result = new JSONObject();
        result.put("ControlCode", cmdBase64Value);
        result.put("DataLen", data.length() / 2);
        return result;
    }


    public static void main(String[] args) throws IOException {
//        getCommonData("","1","390A440400000000","FE53C7375C9DC52337F34772C27B2287D5FFE70C5B5C7A4470FC8B38B556FD7239A421AFBB4A20C4FBF017E53F5188D8ACF4063D2E845E7A6F52912A7220D163","A71D669459F5491B4CD9A91AB51C9F2A43EC8CE0373A5652BDFABE521649BC9A117C3716A7D9DAA5C42CF48DF3EE18AB37DD97D5D8777E4AB45A1823829A9A84",
//                new JSONObject("{\"ControlAck\":\"aDAAARIhAAAZhAAQJ4wP+S+LQJdQaUrs19QMuCMW\",\"DataLen\":30}"));
        String result = UDPDataParse.ParseData(0,"683000011221000108810010885074FF000000800000000000000000E916");
        String result2 = UDPDataParse.ParseData(0,"6830000111210080288100B088508900210822880501010001010001010001000001000001000001010000010001000001010101018841018848018854018901018920010001019140010100019212010101000100010101000001000001010100010101000100010100010100010001000100010000010195000195040101000197290101010001974201975001019755010000019810010198160100010101020100019834010001A14801000101000101000101800000000000005016");
    }

    public static JSONObject getChargeResult(Object code){
        JSONObject result = new JSONObject();
        String codeStr = String.valueOf(code);
        if(chargeResultCodeDictionary.containsKey(codeStr)){
            String msg = chargeResultCodeDictionary.get(codeStr);
            result.put("msg",msg);
            if(!("04".equals(codeStr) || "06".equals(codeStr))){
                result.put("isReset",1);
            } else {
                result.put("isReset",0);
            }
        } else {
            result.put("msg","未知错误:"+codeStr);
            result.put("isReset",1);
        }
        return result;
    }

    /**
     * 解析数据
     *
     * @param deviceId     设备号
     * @param isSessionKey 是否已协商密钥
     * @param seUid        seUid
     * @param seKey        seKey
     * @param seTempKey    seTempKey
     * @param dataObject   待解析数据
     * @return 解析后数据
     * @throws IOException IO异常
     */
    public static JSONObject getTransData(String deviceId, String isSessionKey, String seUid, String seKey, String seTempKey, JSONObject dataObject) throws IOException {
        String transData_hex = TranscodeUtil.byteArrayToHexStr(
                TranscodeUtil.base64StrToByteArray(dataObject.get("TransData").toString()));
        int isEncry = 1;
        if (StringUtils.isNotBlank(isSessionKey) && isSessionKey.equals("1")) {
            // 解密
            try {
                transData_hex = UDPDataParse.DecryptData_SE(
                        seUid,
                        seKey,
                        seTempKey,
                        "ranStr",
                        transData_hex
                );
            } catch (Exception e) {
                LOGGER.error("解密时发生错误，尝试直接解析：", e);
            }
            isEncry = 0;
        }
        // 数据解析
        LOGGER.debug("解码前数据:"+transData_hex);
        String result = UDPDataParse.ParseData(isEncry, transData_hex);
        JSONObject resultObject = new JSONObject(result);
        LOGGER.debug("解析内容："+ resultObject);
        // 如果解析失败，则下发协商密钥请求
        if(resultObject.getString("Result").equals("Err")){
            isSessionKey = null;
        }
        // 判断是否需要下发协商密钥请求
        if ((isSessionKey == null || isSessionKey.equals("0")) && !(result.substring(result.indexOf('@') + 1).equals("0000000000000000"))) {
            // 表号
            String meterNumber = resultObject.getString("CodeNumber");
            JSONObject keyResult = new JSONObject(
                    UDPDataParse.WriteGetSEKey(meterNumber, 1, "")
            );
            if (keyResult.getString("Result").equals("SUCCESS")) {
                String realData = keyResult.getString("CMDHEXString");
                JSONObject realObject = LaiDeTools.getData(isSessionKey, seUid, seKey, seTempKey, realData);
                LOGGER.debug("下发协商密钥请求 读出SE密钥信息:" + realObject);
                SignalDeliveryTools.myPostCommand("MeterControl", "Control", deviceId, realObject);
            } else {
                LOGGER.error("下发协商密钥请求 解析失败");
            }
            return null;
        } else {
            return resultObject;
        }
    }
    public static JSONObject getTransData(JSONObject dataObject) throws IOException {
        String transData_hex = TranscodeUtil.byteArrayToHexStr(
                TranscodeUtil.base64StrToByteArray(dataObject.get("TransData").toString()));
        int isEncry = 1;
        // 数据解析
        LOGGER.debug("解码前数据:"+transData_hex);
        String result = UDPDataParse.ParseData(isEncry, transData_hex);
        JSONObject resultObject = new JSONObject(result);
        LOGGER.debug("解析内容："+ resultObject);
        return resultObject;
    }

    public static String getMeternumber(JSONObject resultDetail){
        String controlAckData_hex = TranscodeUtil
                .byteArrayToHexStr(TranscodeUtil.base64StrToByteArray(resultDetail.get("TransData").toString()));
        // 表号
        return controlAckData_hex.substring(4, 18);
    }

    public static JSONObject getCommonData(String deviceId, String isSessionKey, String seUid, String seKey, String seTempKey, JSONObject resultDetail) throws IOException {
        JSONObject result = new JSONObject();
        String controlAckData = resultDetail.get("ControlAck").toString();
        if("".equals(controlAckData)){
            return null;
        }
        String controlAckData_hex = TranscodeUtil
                .byteArrayToHexStr(TranscodeUtil.base64StrToByteArray(controlAckData));
        // 表号
        String MeterNo = controlAckData_hex.substring(4, 18);
        if (controlAckData_hex.length() >= 30) {
            if (controlAckData_hex.startsWith("89", 18) & controlAckData_hex.startsWith("D000", 24)) {
                //说明为对密钥协商请求的回复
                JSONObject parseCmdExResult = new JSONObject(UDPDataParse.ParseData(0, controlAckData_hex));
                JSONObject parseCmdExResultDetail = parseCmdExResult.getJSONObject("Data");
                LOGGER.debug("下发写入协商密钥请求");
                JSONObject keyResult = new JSONObject(
                        UDPDataParse.WriteSetSessionKey(
                                MeterNo,
                                1,
                                parseCmdExResultDetail.getString("SEUID") + "#" +
                                        parseCmdExResultDetail.getString("SESM2Key") + "#" +
                                        parseCmdExResultDetail.getString("SEtempSm2Key") + "#" +
                                        parseCmdExResultDetail.getString("RandStr")
                        )
                );
                if (keyResult.getString("Result").equals("SUCCESS")) {
                    String realData = keyResult.getString("CMDHEXString");
                    JSONObject realObject = LaiDeTools.getData("0", null, null, null, realData);
                    LOGGER.debug("下发写入协商密钥请求:" + realObject + " 完成");
                    SignalDeliveryTools.myPostCommand("MeterControl", "Control", deviceId, realObject);
                } else {
                    LOGGER.error("下发写入协商密钥请求 解析失败");
                }
                parseCmdExResultDetail.put("type", "1");
                return parseCmdExResultDetail;
            } else if (controlAckData_hex.startsWith("89", 18) & controlAckData_hex.startsWith("D001", 24)) {
                //说明对下发写入协商密钥请求的回复
                result.put("type", "2");
                return result;
            }
        }
        //说明是对其他类型指令的回复
        int isEncry = 1;
        if (StringUtils.isNotBlank(isSessionKey) && isSessionKey.equals("1")) {
            // 解密
            String decryptHex = UDPDataParse.DecryptData_SE(
                    seUid,
                    seKey,
                    seTempKey,
                    "ranStr",
                    controlAckData_hex
            );
            isEncry = 0;
            if(decryptHex != null){
                controlAckData_hex = decryptHex;
            }
        }
        LOGGER.debug("解码前数据:"+controlAckData_hex);
        result = new JSONObject(UDPDataParse.ParseData(isEncry, controlAckData_hex));
        result.put("type", "3");
        return result;
    }
    public static JSONObject getCommonData(JSONObject resultDetail) throws IOException {
        String controlAckData_hex = TranscodeUtil
                .byteArrayToHexStr(TranscodeUtil.base64StrToByteArray(resultDetail.get("ControlAck").toString()));
        int isEncry = 1;
        // 数据解析
        LOGGER.debug("解码前数据:"+controlAckData_hex);
        String result = UDPDataParse.ParseData(isEncry, controlAckData_hex);
        JSONObject resultObject = new JSONObject(result);
        LOGGER.debug("解析内容："+ resultObject);
        return resultObject;
    }


    public static JSONObject getTransCommonData(JSONObject resultDetail) {
        JSONObject result;
        String controlAckData = resultDetail.get("ControlAck").toString();
        String controlAckData_hex = TranscodeUtil
                .byteArrayToHexStr(TranscodeUtil.base64StrToByteArray(controlAckData));
        //说明是对获取随机数指令的回复
        int isEncry = 0;
        result = new JSONObject(UDPDataParse.ParseData(isEncry, controlAckData_hex));
        result.put("type", "3");
        return result;
    }

    public static String getUploadType(JSONObject params, String flag) {
        Iterator<String> iterator = params.keys();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()){
            String key = iterator.next();
            if(params.getString(key).equals("1")){
                String value = uploadTypeDictionary.get(key);
                if(value.equals("流量异常上报")){
                    if(flag == null){
                        flag = "-1";
                    }
                    value = value + "(" + flag + ")";
                }
                builder.append(value).append(" ");
            }
        }
        if(builder.length() == 0){
            if(flag != null){
                return flag;
            } else {
                return "无上报标志";
            }
        }
        builder.deleteCharAt(builder.lastIndexOf(" "));
        return builder.toString();
    }

    public static JSONArray getPulseArray(String beginDate,String userId){
        //获取当前上报时间
        DateTime now = DateTime.now();
        DateTime metereadDate;
        //获取最后一次上报时间
        if(beginDate == null){
            metereadDate = new DateTime(now);
            metereadDate.offset(DateField.DAY_OF_MONTH, -1);
        } else {
            metereadDate = DateUtil.parse(beginDate);
        }
        //获取未抄表总天数
        int days = (int) DateUtil.betweenDay(metereadDate,now,true);
        //最多有40天的脉冲
        if(days > 40){
            days = 40;
        }
        JSONArray array = new JSONArray(days);
        for(int i = 0; i < days; i++){
            now.offset(DateField.DAY_OF_MONTH, -1);
            JSONObject item = new JSONObject();
            item.put("userId",userId);
            item.put("title","读取脉冲数据-"+now.toDateStr());
            item.put("inputtor","系统必需");
            JSONObject content = new JSONObject();
            content.put("readType","读取脉冲数据");
            content.put("pulseDay",i);
            item.put("content",content);
            array.put(item);
        }
        return array;
    }

    public static String getPulseDayNumber(String title){
        //从指令标题中取到要读取的数据日期
        String date = title.substring(title.indexOf("-") + 1);
        //与当前日期作比较，得到相差天数
        String diffDays = DateTools.getDateDayBetween(date,DateTools.getNow("yyyy-MM-dd"),true);
        //0：昨天数据 1：前天数据 2：大前天数据，以此类推，所以要-1
        int diffValue = Integer.parseInt(diffDays) - 1;
        if(diffValue < 0){
            diffValue = 0;
        }
        return String.valueOf(diffValue);
    }

    public static JSONObject setOrGetFlowCache(JSONObject data){
        String meterNumber = data.getString("CodeNumber");
        JSONObject resultData = data.getJSONObject("Data");
        int finalFlag = resultData.getInt("FinalFlag");
        String thisCacheData = resultData.getJSONArray("data").toString();
        thisCacheData = thisCacheData.substring(1,thisCacheData.length()-1);
        boolean isOk = false;
        //如果表号对应的缓存存在
        if(flowDataCache.containsKey(meterNumber)){
            //追加脉冲数据，此处用StringBuilder，引用传递类型，调用append方法会修改map中的StringBuilder引用，不需要再调用map的put方法
            String historyCacheData = flowDataCache.get(meterNumber).append(",").append(thisCacheData).toString();
            //如果是最后一段数据
            if(finalFlag == 0){
                //拼接外层数据
                resultData.put("data",new JSONArray("["+historyCacheData+"]"));
                //移除缓存
                removeFlowCache(meterNumber);
                //直接返回结果
                isOk = true;
            }
        } else {
            //如果是最后一段数据
            if(finalFlag == 0){
                isOk = true;
            } else {
                //加入缓存
                flowDataCache.put(meterNumber,new StringBuilder(thisCacheData));
            }
        }
        if(isOk){
            JSONArray datas = resultData.getJSONArray("data");
            while (resultData.toString().length() > 4000){
                datas.remove(datas.length()-1);
            }
            return data;
        }
        return null;
    }

    public static void removeFlowCache(String meterNumber){
        flowDataCache.remove(meterNumber);
    }

    public static double getUseGasTotal(JSONObject params){
        double count = 0;
        JSONArray pulseData = params.getJSONArray("data");
        for(int i = 0; i < pulseData.length(); i++){
            JSONObject item = pulseData.getJSONObject(i);
            String useGasStr = item.getString("d");
            JSONArray useGasItem = CommonTools.split(useGasStr,"|");
            for(int j = 0; j < useGasItem.length() - 1; j++){
                int value = useGasItem.getInt(j);
                count = count + value;
            }
        }
        count = CommonTools.div(count,100).doubleValue();
        return count;
    }

    public String getReplyType(String replyName){
        return replyDictionary.get(replyName);
    }
}
