package com.aote.webmeter.module.main.jinkasyncsystem;

import com.af.plugins.CommonTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

/**
 * 金卡系统(新)应用接口鉴权(同样适用于JinKaSystem)
 *
 * @author Mr.river
 */
public class GetTokenTools {

	private static final Logger LOGGER = Logger.getLogger(GetTokenTools.class);
	/**
	 * 超时时间值 9分钟 / 10分钟
	 */
	private static final Integer TOKEN_TIMEOUT_VALUE = 1000 * 60 * 9;
	/**
	 * 鉴权有效时间
	 */
	private static Long STAMP = null;
	/**
	 * 请求头
	 */
	private static JSONObject AOD = null;

	private static final String MAC_NAME = "HmacSHA1";
	private static final String ENCODING = "UTF-8";

	/**
	 * 获取请求头
	 *
	 * @return 请求头
	 */
	public static JSONObject getHeader() throws Exception {
		JSONObject token = getRequestHeader();
		if (token != null) {
			return token;
		} else {
			return getWebHeader();
		}
	}

	/**
	 * 发起获取请求头的请求
	 *
	 * @return 请求头信息
	 */
	private static synchronized JSONObject getWebHeader() throws Exception {
		JSONObject header = getRequestHeader();
		if (header == null) {
			String appId = WebMeterInfo.getString("HMACkey");
			LOGGER.info(appId + ":进行金卡鉴权操作");
			AOD = createHeader();
			STAMP = System.currentTimeMillis();
			return AOD;
		}
		return header;
	}

    public static JSONObject createHeader() throws Exception {
		JSONObject header = new JSONObject();
		String hmacKey = WebMeterInfo.getString("HMACkey");
		String nowTime = String.valueOf(System.currentTimeMillis());
		int random = CommonTools.getRandomNumber(100000,999999);
		String encryptText = hmacKey + nowTime + random;
		String encryptKey = WebMeterInfo.getString("HMACsecret");
		byte[] data = encryptKey.getBytes(ENCODING);
		//根据给定的字节数组构造一个密钥,第二参数指定一个密钥算法的名称
		SecretKey secretKey = new SecretKeySpec(data, MAC_NAME);
		//生成一个指定 Mac 算法 的 Mac 对象
		Mac mac = Mac.getInstance(MAC_NAME);
		//用给定密钥初始化 Mac 对象
		mac.init(secretKey);

		byte[] text = encryptText.getBytes(ENCODING);
		//完成 Mac 操作
		byte[] rawHmac = mac.doFinal(text);
		//转换格式得到密钥
		String sign = Hex.encodeHexString(rawHmac);
		header.put("hmacalgo","hmacsha1");
		header.put("hmackey",hmacKey);
		header.put("hmacrand",String.valueOf(random));
		header.put("hmactime",nowTime);
		header.put("hmacver","v1");
		header.put("hmacsign",sign);
		header.put("Content-Type","application/json");
		return header;
	}

	private static JSONObject getRequestHeader() {
		long current = System.currentTimeMillis();
		JSONObject header = AOD;
		Long stampValue = STAMP;
		if (header != null && stampValue != null && (current - stampValue) < TOKEN_TIMEOUT_VALUE) {
			LOGGER.info("获取现有的金卡请求头");
			return header;
		} else {
			return null;
		}
	}
}
