package com.aote.webmeter.module.main.jinkasyncnb;

import com.af.plugins.CommonTools;
import com.af.plugins.ConvertTools;
import com.af.plugins.DateTools;
import com.af.plugins.RestTools;
import org.json.JSONArray;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * 金卡NB金额表对接兼容工具
 *
 * @author Mrriver
 */
public class JinKaMoneyTools {

    public static String analysisCommand(String command){
        JSONObject ret = new JSONObject(RestTools.get(
                RestTools.formatURL("http://127.0.0.1:10010/jk10/v1/unPackData",new JSONObject()
                        .put("packet",command))
        ));
        if("".equals(ret.getString("unPacketData"))){
            return "0";
        }
        String type = ret.getString("datetype");
        if(!type.equals("1")){
            JSONObject result = new JSONObject();
            result.put("meterId",ret.getString("meterId"));
            result.put("type",type);
            result.put("unPacketData",ret.getString("unPacketData"));
            return result.toString();
        }
        JSONArray array = CommonTools.split(ret.getString("unPacketData"),",");
        int length = array.length();
        String meterStateParameters = new StringBuilder(
                ConvertTools.hexStrToBinaryStr(array.getString(length-3))
        ).reverse().toString();
        char[] meterState = JinKaMoneyTools.reverse(ConvertTools.binaryStrToBinaryArray(meterStateParameters));
        int day = array.getInt(3);

        JSONObject result = new JSONObject();
        result.put("meterId",ret.getString("meterId"));
        result.put("type",type);
        result.put("date", DateTools.formatDateTime(array.getString(0),"yyMMddHHmmss"));
        result.put("meterState",meterState);
        String tablebaseNumber = array.getString(5 + (day - 1));
        result.put("tablebaseNumber",Double.parseDouble(tablebaseNumber) / 10);
        result.put("signalIntensity",array.getDouble(length-2));
        result.put("voltage",array.getDouble(length-1));
        return result.toString();
    }

    public static String formatHandDate(JSONObject dateDetail) throws ParseException {
        return dateDetail.get("year") + "-" +
                dateDetail.get("monthValue") + "-" +
                dateDetail.get("dayOfMonth") + " " +
                dateDetail.get("hour") + ":" +
                dateDetail.get("minute") + ":" +
                dateDetail.get("second");
    }

    public String formatHandDate2(Long date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    public static char[] reverse(byte[] data) {
        //转换结果
        StringBuilder result = new StringBuilder();
        //中间存储
        StringBuilder itemStr = new StringBuilder();
        for (int i = 1; i < data.length; i++) {
            if (i % 8 == 0) {
                itemStr.append(data[i - 1]);
                itemStr.reverse();
                result.append(itemStr);
                itemStr.setLength(0);
            } else {
                itemStr.append(data[i - 1]);
            }
        }
        return result.toString().toCharArray();
    }

    public static void main(String[] args) {
        String json = analysisCommand("7A72B91F0000000000000018202621205301012675FF985A3CDE68000000003333333333333336323232323232323233333336333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333389E6206400020003000A00ECEC0000420000000E062205210805113314A2F1504CAA");
        System.out.println(json);
//        System.out.println(reverse(ConvertTools.binaryStrToBinaryArray("1000000100000110100000000000000000000000")));
    }
}
