package com.aote.webmeter.module.main.jichengsystem;

import com.af.plugins.RestTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import java.lang.management.ManagementFactory;
import java.util.Set;

/**
 * 积成抄表系统工具类
 */
public class JiChengSystemTools {
    private static final Logger log = Logger.getLogger(JiChengSystemTools.class);
    private static String url;
    private static String syncSystemUrl;
    private static String SystemUrl;
    private static String exceptionUrl;
    private static String syncExceptionUrl;

    static {
        //获取当前服务的端口
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = null;
        boolean isOK;
        try {
            objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("org.apache.coyote.http11.Http11AprProtocol")));
            isOK = true;
        } catch (Exception e) {
            try {
                objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
                isOK = true;
            } catch (MalformedObjectNameException e2) {
                log.error("出现异常：", e2);
                isOK = false;
            }
        }
        if (isOK) {
            String port = objectNames.iterator().next().getKeyProperty("port");
            //定义Logic请求地址
            url = "http://localhost:" + port + "/webmeter/rs/logic/JiChengSystemCallBackData";
            exceptionUrl = "http://localhost:" + port + "/webmeter/rs/logic/JiChengSystemExceptionCallBackData";
            syncExceptionUrl = "http://localhost:" + port + "/webmeter/rs/logic/JiChengSyncSystemExceptionCallBackData";
            syncSystemUrl = "http://localhost:" + port + "/webmeter/rs/logic/JiChengSyncSystemCallBackData";
            SystemUrl = "http://localhost:" + port + "/webmeter/rs/logic/JiChengSystemCallBackData";
        }
    }

    /**
     * 积成抄表
     *
     * @param array
     * @return
     */
    public static JSONArray handPlan(JSONArray array) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < array.length(); i++) {
            try {
                JSONObject response = null;
                // 按照和积成协商用此字段区分10或40
                JSONObject item = array.getJSONObject(i);
                if (item.has("protocol_name") && item.get("protocol_name") != JSONObject.NULL){
                    if (item.get("protocol_name").equals("表端结算")){
                        response = new JSONObject(RestTools.post(SystemUrl, item));
                    } else if(item.get("protocol_name").equals("系统结算")){
                        response = new JSONObject(RestTools.post(syncSystemUrl, item));
                    } else {
                        log.error("不支持的表具类型："+item);
                        response = new JSONObject();
                        response.put("customer_code",item.getString("customer_code"));
                        response.put("sign",WebMeterInfo.getString("tag"));
                        response.put("returnvalue","1");
                    }
                } else {
                    log.info("没有结算类型："+item);
                    response = new JSONObject();
                    response.put("customer_code",item.getString("customer_code"));
                    response.put("sign",WebMeterInfo.getString("tag"));
                    response.put("returnvalue","0");
                }
                if (!response.has("status")) {
                    result.put(response);
                }
            } catch (Exception e) {
                log.error("抄表时请求发生异常:", e);
            }
        }
        return result;
    }

    public static JSONArray saveException(JSONArray array) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < array.length(); i++) {
            try {
                String moduleName = WebMeterInfo.getModuleName();
                String url;
                if(moduleName.equals("JiChengSystem")){
                    url = exceptionUrl;
                } else {
                    url = syncExceptionUrl;
                }
                JSONObject response = new JSONObject(RestTools.post(url, array.getJSONObject(i)));
                if (!response.has("status")) {
                    result.put(response);
                }
            } catch (Exception e) {
                log.error("获取异常信息时请求发生异常:", e);
            }
        }
        return result;
    }
}
