package com.aote.webmeter.module.main.huatengsyncsystem;

import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author zhaotong
 *
 */
public class Tools {

	private static Logger log = Logger.getLogger(Tools.class);

	private static JSONObject jo;

	// 主动查询自动生成uuid
	public static String getUUID() {
		return UUID.randomUUID().toString().toUpperCase().replace("-", "");
	}
	// 将的uuid变成大写
	public static String getUUID(String uuid) {
		return uuid.toUpperCase();
	}
	//将uuid变成小写
	public static String getLowerUUID(String uuid) {
		return uuid.toLowerCase();
	}

	@Deprecated
	public static String getSignValue(JSONObject sjo, String key) {
		jo = new JSONObject();
		getContent(sjo);
		JSONObject to = new JSONObject(jo.toString());
		Set<String> set = to.keySet();
		for (String s : set) {
			if (to.get(s).equals("") || to.get(s) == null ||
					to.get(s) instanceof JSONArray
			) {
				jo.remove(s);
			}
		}

		log.debug(jo);

		StringBuilder sbu = new StringBuilder();
		List<String> list1 = new ArrayList<String>(jo.keySet());
		Collections.sort(list1);
		for (int i = 0; i < list1.size(); i++) {
			char ch = ' ';
			if (i < list1.size() - 1) {
				ch = '&';
			}
			sbu.append(list1.get(i)).append("=").append(jo.get(list1.get(i)).toString()).append(ch);
		}

		String stringSignTemp = sbu.toString().trim() + "&key=" + key;

		log.debug("Md5编码前字符串" + stringSignTemp);
		String md5str = "";
		StringBuffer sb=null;
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			md.update(stringSignTemp.getBytes());
			 sb = new  StringBuffer();
			 byte[] bytes=md.digest();
			for (byte aByte : bytes) {
				String s = Integer.toHexString(0xff & aByte);
				if (s.length() == 1) {
					sb.append("0").append(s);
				} else {
					sb.append(s);
				}
			}
			md5str=sb.toString();

		} catch (Exception e) {
			e.printStackTrace();
		}
		return md5str.toUpperCase();
	}


	private static void getContent(JSONObject temp) {
		Set<String> set = temp.keySet();
		for (String s : set) {
			if (temp.get(s) instanceof JSONObject) {
				getContent((JSONObject) temp.get(s));
			} else {
				jo.put(s, temp.get(s));
			}
		}
	}



	public static JSONObject str2JSONObject(Object str) {
		return new JSONObject(str.toString());
	}


	public static JSONArray str2JSONArray(String str) {
		return new JSONArray(str);
	}

	public static JSONArray str2JsonArray(Object str){
		JSONArray jArray = new JSONArray(str.toString());
		return jArray;
	}

	public String judgeResult(JSONObject jo, String type) {
		String result = "error";

		try{
			if(jo.getString("returncode").equals("SUCCESS")
					&& jo.getString("resultcode").equals("SUCCESS")
			)
				result = "SUCCESS";
			else
				if(jo.has("errorcode"))
					result = jo.getString("errorcode");
				else if(jo.has("errormsg"))
					result = jo.getString("errormsg");
				else
					result = "未知错误";

		}catch (Exception e){
			log.error(e);
		}

		return result;
	}

	public static void main(String[] args) {
		String str = "{\"metertype\":3,\"settings\":{\"apriceperiod\":\"1\",\"astepprices\":[{\"max\":0,\"price\":2.84}],\"apricetime\":\"12\",\"apricetype\":\"1\",\"astartdate\":\"20200101\"},\"rechargetimes\":1,\"signtype\":\"MD5\",\"uuid\":\"2222A811DC3B4559825BCF7E92B5E709\",\"prepaytype\":0,\"settingtype\":1,\"rechargequantity\":\"0.00\",\"partner\":\"2c9a6e09712936c5017129e3d1790f77\",\"appid\":\"2c9a6e09712936c5017129e3d1790f77\",\"nettype\":\"1\",\"meterno\":\"1532002010006015\",\"rechargeamount\":\"0.00\",\"notifyurl\":\"http://39.106.157.179:8080/HuaTengMeter/rs/logic/callback_OpenAccount\"}";
		String key = "68f2a26e54ae47e9875eebbf33590e74";
		JSONObject job = new JSONObject(str);
		System.out.println(Tools.getSignValue(job, key));

 	}

	public static String getDate(){

		SimpleDateFormat sdf =  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return sdf.format(new Date());
	}

	public static String[] split(String string,String a){
		return string.split(a);
	}


	public static String  fix(String string ){
		DecimalFormat dFormat  = new DecimalFormat("#0.00");
		return   dFormat.format(Double.valueOf(string));
	}


}
