package com.aote.webmeter.module.main.huatengsyncsystem;

import com.af.plugins.CommonTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HuaTengUtil {
    /**
     * 生成签名
     * @param params 参数JSON
     * @return 签名
     */
    public static String getSignValue(JSONObject params) {
        if(params.has("signtype")){
            params.remove("signtype");
        }
        // 排序输出字符串
        StringBuilder sbu = new StringBuilder();
        Map<String,Object> paramsMap = params.toMap();
        getContent(paramsMap,params);
        List<String> keyList = new ArrayList<>(paramsMap.keySet());
        Collections.sort(keyList);
        for (String key : keyList) {
            Object value = paramsMap.get(key);
            if (!((value instanceof String && value.equals(""))
                    || value instanceof JSONArray || value instanceof JSONObject)) {
                sbu.append(key).append("=").append(value).append("&");
            }
        }
        // 追加key
        sbu.append("key=").append(WebMeterInfo.getString("key"));
        return CommonTools.md5(sbu.toString()).toUpperCase();
    }

    private static void getContent(Map<String,Object> params,JSONObject temp) {
        for (String s : temp.keySet()) {
            Object item = temp.get(s);
            if (item instanceof JSONObject) {
                params.remove(s);
                getContent(params,(JSONObject) item);
            } else {
                params.put(s, temp.get(s));
            }
        }
    }

    public static void main(String[] args) {
        JSONObject params = new JSONObject("{\"appid\":\"2c9a6e0971a644300172ca2cc8a43eb2\",\"partner\":\"2c9a6e0971a644300172ca2cc8a43eb2\",\"uuid\":\"8A442A8885BE4226A8AA9930850A1A3D\",\"meterno\":\"1402007000002015\",\"prepaytype\":0,\"metertype\":3,\"nettype\":1,\"rechargetimes\":1,\"rechargequantity\":\"0.00\",\"rechargeamount\":\"100.00\",\"notifyurl\":\"http:\\/\\/113.24.59.231:8002\\/api\\/notify\\/openaccount\",\"settingtype\":3,\"settings\":{\"astartdate\":\"20180701\",\"apricetype\":1,\"apriceperiod\":1,\"astepprices\":[{\"max\":0,\"price\":3.20}]},\"signtype\":\"MD5\",\"sign\":\"\"}");
        System.out.println(getSignValue(params));
        System.out.println(getSignValue(params));
        System.out.println(new HuaTengTool().signature(params,"d0a897954c106f893caf0a93e85819a6").get("sign"));
    }
}
