package com.aote.webmeter.module.main.huatengsyncsystem;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.crypto.digest.DigestUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

/**
 * 华腾工具插件
 */
public class HuaTengTool {

    private JSONObject params;

    public JSONObject signature(JSONObject content, String key) {
        params = new JSONObject();
        getContent(content);
        JSONObject paramsCopy = new JSONObject(params.toString());
        for (String s : paramsCopy.keySet()) {
            if (paramsCopy.get(s).equals("") || paramsCopy.get(s) == null ||
                    paramsCopy.get(s) instanceof JSONArray
            ) {
                params.remove(s);
            }
        }
        Set<String> paramsKeys = params.keySet();
        ArrayList<String> paramsList = ListUtil.toList(paramsKeys);
        Collections.sort(paramsList);
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < paramsList.size(); i++) {
            sign.append(paramsList.get(i)).append("=").append(params.get(paramsList.get(i))).append("&");
        }
        sign.append("key=").append(key);
        content.put("sign", DigestUtil.md5Hex(sign.toString()).toUpperCase());
        return content;
    }

    private void getContent(JSONObject temp) {
        for (String s : temp.keySet()) {
            if (temp.get(s) instanceof JSONObject) {
                getContent((JSONObject) temp.get(s));
            } else {
                params.put(s, temp.get(s));
            }
        }
    }


    public static JSONObject resultFormat(JSONObject res, Integer instructId) {
        JSONObject ret = new JSONObject();
        String resultCode = getJsonStr(res, "resultcode", "ERROR");
        ret.put("metaData", res);
        ret.put("id", instructId);
        if ("SUCCESS".equals(resultCode)) {
            ret.put("status", "2");
        } else {
            String resultMsg = getJsonStr(res, "errormsg", "回传信息加载失败，未返回或标识异常。");
            ret.put("status", "1");
            ret.put("receiveMsg", resultMsg);
        }
        return ret;
    }

    public static String dateFormat(String time) {
        DateTime dateTime = DateUtil.parse(time, "yyyyMMddHHmmss");
        return DateUtil.formatDateTime(dateTime);
    }

    public static String genUUID() {
        return IdUtil.fastSimpleUUID();
    }

    public static String getJsonStr(JSONObject data, String key, String defaultValue) {
        try {
            return data.getString(key);
        } catch (JSONException e) {
            return defaultValue;
        }
    }


    public static JSONObject addPriceInfo(JSONObject data, JSONArray priceInfo) {
        if (priceInfo == null) {
            return null;
        }
        JSONArray astepprices = new JSONArray();
        int i = 0;
        for (; i < priceInfo.length() && i < 6; i++) {
            JSONObject temp = new JSONObject();
            JSONObject priceItem = priceInfo.getJSONObject(i);
            temp.put("max", priceItem.getDouble("f_gas"));
            temp.put("price", priceItem.getDouble("f_price"));
            astepprices.put(temp);
        }
        String date = priceInfo.getJSONObject(0).getString("f_perform_date");
        DateTime time = DateUtil.parseDate(date);
        data.put("astartdate",DateUtil.format(time,"yyyyMMdd"));
        data.put("apricetype",i);
        data.put("astepprices",astepprices);
        return data;
    }
}
