package com.aote.webmeter.module.main.hailisystem;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import com.aote.webmeter.module.main.jinkasyncsystem.GetTokenTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @PackageName: com.aote.webmeter.module.main.HaiLiSystem
 * @ClassName: HaiLiSystemTools
 * @Author: lin
 * @Date: 2021/7/8 11:18
 * @Description:
 */
public class HaiLiSystemTools {

    private static final Logger LOGGER = Logger.getLogger(GetTokenTools.class);
    //有效时间
    private static String validPeriod = null;
    //公司ID
    private static String mainTenantId = null;
    //授权码信息
    private static String AccessToken = null;
    //授权码类型
    private static String TokenType = null;

    /**
     * 鉴权主入口
     * @return 请求海力的鉴权接口的返回值，不知日后是否还需更多参数，暂时获取到的全部返回
     */
    public static JSONObject uthorization () throws Exception {
        JSONObject js = new JSONObject();
        if (validPeriod == null || DateTools.compareDate(String.valueOf(DateTools.getNow()),validPeriod)){
            Date now = DateTools.getNow();
            js = getUserId();
            Date newDate = addSeconds(now, js.getInt("ExpiresIn"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-M-dd HH:mm:ss");
            String effective = sdf.format(newDate.getTime());
            validPeriod = effective;
            mainTenantId = js.getString("MainTenantId");
            AccessToken = js.getString("AccessToken");
            TokenType = js.getString("TokenType");
        }else {
            LOGGER.info("获取现有的海力鉴权");
            js.put("MainTenantId",mainTenantId);
            js.put("AccessToken",AccessToken);
            js.put("TokenType",TokenType);
        }
        return js;
    }

    /**
     * 计算多少秒后的当前时间
     * @param date  需要计算的时间
     * @param seconds  需要计算的秒数
     * @return
     */
    private static Date addSeconds(Date date, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        // 此处防止通讯造成时间差，故对有有效期少算6分钟
        calendar.add(Calendar.SECOND, seconds-360);
        return calendar.getTime();
    }
    /**
     * 组装参数并请求海力鉴权接口
     * @return
     */
    private static synchronized JSONObject getUserId() throws Exception {
        JSONObject content = new JSONObject();
        content.put("AccountName", WebMeterInfo.getString("AccountName"));
        content.put("AccountPassword", WebMeterInfo.getString("AccountPassword"));
        content.put("ClientId", WebMeterInfo.getString("ClientId"));
        content.put("ClientSecret", WebMeterInfo.getString("ClientSecret"));
        String url = WebMeterInfo.getString("uthorizationUrl");
        JSONObject params = new JSONObject();
        params.put("Data",content);
        params.put("Method","OwnerPasswordCredentialInfo");
        JSONObject sign = getSign("OwnerPasswordCredentialInfo");
        params.put("Timestamp",sign.getString("Timestamp"));
        params.put("Sign",sign.getString("signValue"));
        LOGGER.info("请求海力鉴权");
        String ret = RestTools.post(url, params);
        JSONObject rets = JsonTools.convertToJson(ret);
        if ( rets.getBoolean("IsSucceed")){
            LOGGER.info("获取海力鉴权成功");
        }else {
            throw new RuntimeException("海力鉴权失败！，错误信息：" + rets.get("Error"));
        }
        return rets.getJSONObject("Result");
    }

    /**
     * 获取当前时间的unix格式，精确到秒
     * @return
     */
    public static String getUnix(){
        long newDate = System.currentTimeMillis();
        String unixDate = String.valueOf(newDate / 1000);
        return unixDate;
    }

    /**
     * 进行MD5加密
     * @param params
     * @return
     * @throws Exception
     */
    public static JSONObject getSign(String params) throws Exception {
        String Timestamp = getUnix();
        String data = "Timestamp="+Timestamp+"+Method="+params;
        // 生成一个MD5加密计算摘要
        MessageDigest md = MessageDigest.getInstance("MD5");
        // 计算md5函数
        md.update(data.getBytes());
        // digest()最后确定返回md5 hash值，返回值为8位字符串。因为md5 hash值是16位的hex值，实际上就是8位的字符
        // BigInteger函数则将8位的字符串转换成16位hex值，用字符串来表示；得到字符串形式的hash值
        //一个byte是八位二进制，也就是2位十六进制字符（2的8次方等于16的2次方）
        String ret = new BigInteger(1, md.digest()).toString(16);
        JSONObject rets = new JSONObject();
        rets.put("Timestamp",Timestamp);
        rets.put("signValue",ret);
        return  rets;
    }
}
