package com.aote.webmeter.module.main.chengdesystem;

import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.math.BigInteger;
import java.security.MessageDigest;

/**
 * @PackageName: com.aote.webmeter.module.main.ChengDeSystem
 * @ClassName: chengDeSysetemTools
 * @Author: 林
 * @Date: 2021/8/2 17:08
 * @Description:
 */
public class ChengDeSysetemTools {

    private static final Logger LOGGER = Logger.getLogger(ChengDeSysetemTools.class);

    /**
     * 超时时间值 45分钟
     */
    private static final Integer TOKEN_TIMEOUT_VALUE = 1000 * 60 * 45;
    /**
     * 鉴权有效时间
     */
    private static Long STAMP = null;
    /**
     * 请求头
     */
    private static JSONObject AOD = null;

    /**
     * 获取请求头
     *
     * @return 请求头
     */
    public static JSONObject getHeader() throws Exception {
        JSONObject token = getRequestHeader();
        if (token != null) {
            return token;
        } else {
            return getWebHeader();
        }
    }

    /**
     * 发起获取请求头的请求
     *
     * @return 请求头信息
     */
    private static synchronized JSONObject getWebHeader() throws Exception {
        JSONObject header = getRequestHeader();
        if (header == null) {
            LOGGER.info( "进行承德鉴权操作");
            AOD = createHeader();
            STAMP = System.currentTimeMillis();
            return AOD;
        }
        return header;
    }

    private static JSONObject createHeader() throws Exception {
        // 用户登录名
        String accessKey = WebMeterInfo.getString("accessKey");
        // 用户类型operator:操作员， meter：表用户
        String userType = WebMeterInfo.getString("userType");
        // 公司唯一码
        String companyCode = WebMeterInfo.getString("companyCode");
        // 用户登录密码
        String secretKey = getSign(companyCode);
        JSONObject params = new JSONObject();
        params.put("accessKey",accessKey);
        params.put("secretKey",secretKey);
        params.put("userType",userType);
        params.put("companyCode",companyCode);
        String url = WebMeterInfo.getString("getTokenUrl");
        LOGGER.info("发送的请求参数："+params);
        String ret = RestTools.post(url, params);
        JSONObject rets = JsonTools.convertToJson(ret);
        LOGGER.info("获取到的的承德请求头："+rets);
        return rets;
    }

    /**
     * 进行MD5加密
     * @param params
     * @return
     * @throws Exception
     */
    public static String getSign(String params) throws Exception {
        String data = params+"#"+WebMeterInfo.getString("accessKey")+"#"+WebMeterInfo.getString("secretKey");
        // 生成一个MD5加密计算摘要
        MessageDigest md = MessageDigest.getInstance("MD5");
        // 计算md5函数
        md.update(data.getBytes());
        // digest()最后确定返回md5 hash值，返回值为8位字符串。因为md5 hash值是16位的hex值，实际上就是8位的字符
        // BigInteger函数则将8位的字符串转换成16位hex值，用字符串来表示；得到字符串形式的hash值
        //一个byte是八位二进制，也就是2位十六进制字符（2的8次方等于16的2次方）
        String ret = new BigInteger(1, md.digest()).toString(16);
        return  ret;
    }

    private static JSONObject getRequestHeader() {
        long current = System.currentTimeMillis();
        JSONObject header = AOD;
        Long stampValue = STAMP;
        if (header != null && stampValue != null && (current - stampValue) < TOKEN_TIMEOUT_VALUE) {
            LOGGER.info("获取现有的承德请求头");
            return header;
        } else {
            return null;
        }
    }
}
