package com.aote.webmeter.module.main.cangnantcp;

import com.aote.rs.mapper.WebException;
import com.aote.webmeter.tools.CRCUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Iterator;

public class CangNanCommandHelper {

    private static Logger log = Logger.getLogger(CangNanCommandHelper.class);

    private static final String COMPANY_CODE = "3219";

    private static final String CARD_SERVICE_URL = "http://200.100.100.245:9099/GetCNMac";

    private static final byte ADDR_CODE = (byte) 0x17;  //流量计地址

    private static final byte REG_MSG = (byte) 0x53;  //注册包
    private static final byte HEART_BEAT_MSG = (byte) 0xA3;  //心跳包
    private static final byte RECAHRGE_RESPONSE_MSG_1 = (byte) 0x66;  //充值响应
    private static final byte RECAHRGE_RESPONSE_MSG_2 = (byte) 0xA0;  //充值响应
    private static final byte PRICE_ADJUSTMENT_RESPONSE_MSG_1 = (byte) 0x66;  //调价响应
    private static final byte PRICE_ADJUSTMENT_RESPONSE_MSG_2 = (byte) 0xA8;  //调价响应
    private static final byte CLOSE_VALVE_RESPONSE_MSG_1 = (byte) 0x66;  //关阀响应
    private static final byte CLOSE_VALVE_RESPONSE_MSG_2 = (byte) 0xA7;  //关阀响应
    private static final byte READ_METER_RESPONSE_MSG_1 = (byte) 0x03;  //抄表响应
    private static final byte READ_METER_RESPONSE_MSG_2 = (byte) 0xA0;  //抄表响应


    public static int decodeMsgType(String hexStr) {
        try {
            byte[] data = HexUtils.toBytes(hexStr);
            if (data[0] == ADDR_CODE && data[1] == REG_MSG) {
                //注册
                return 11;
            } else if (data[0] == ADDR_CODE && data[1] == HEART_BEAT_MSG) {
                //心跳
                return 12;
            } else if (data[0] == ADDR_CODE && data[1] == RECAHRGE_RESPONSE_MSG_1 && data[3] == RECAHRGE_RESPONSE_MSG_2) {
                //充值响应
                return 21;
            } else if (data[0] == ADDR_CODE && data[1] == CLOSE_VALVE_RESPONSE_MSG_1 && data[3] == CLOSE_VALVE_RESPONSE_MSG_2) {
                //关阀响应
                return 31;
            } else if (data[0] == ADDR_CODE && data[1] == READ_METER_RESPONSE_MSG_1 && data[2] == READ_METER_RESPONSE_MSG_2) {
                //抄表响应
                return 41;
            } else if (data[0] == ADDR_CODE && data[1] == PRICE_ADJUSTMENT_RESPONSE_MSG_1 && data[3] == PRICE_ADJUSTMENT_RESPONSE_MSG_2) {
                //调价响应
                return 51;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    /**
     * 生成充值指令
     *
     * @param meterId
     * @param cardId
     * @param gasValue
     * @param times
     * @return
     */
    public static String createRechargeCommand(String meterId, String cardId, BigDecimal gasValue, BigDecimal times) {
        log.debug("开始构建【充值】指令......");
        byte[] command = new byte[48];
        //构造充值包
        byte[] data = new byte[46];
        byte[] crc;

        //流量计地址
        data[0] = 0x17;
        //功能码
        data[1] = 0x66;
        //data[2]，版本，默认为0
        data[2] = 0;
        //子功能
        data[3] = (byte) 0xA0;
        //长度
        data[4] = 0x29;
        //集中器表号 10(BCD) 不足的前面补0，如00 00 00 00 00 00 00 00 00 01
        meterId = String.format("%020d", Long.parseLong(meterId));
        byte[] dtuId = HexUtils.str2Bcd(meterId);
        System.arraycopy(dtuId, 0, data, 5, 10); //14
        //流量计编号 6(BCD) 即卡号，不足的前面补0，如00 00 00 00 00 01,
        if (cardId.length() > 10) {
            cardId = cardId.substring(0, 10);
        }

        cardId = String.format("%012d", Long.parseLong(cardId));
        byte[] cId = HexUtils.str2Bcd(cardId);
        System.arraycopy(cId, 0, data, 15, 6);  //20
        //公司代号 2(BCD) 如  3411  3219
        byte[] companyCode = HexUtils.str2Bcd(COMPANY_CODE);
        System.arraycopy(companyCode, 0, data, 21, 2);
        //备用命令 5(Hex) 后期扩展 27
        //购气次数 2(Hex) 如 02H，即第 2 次购气
        byte[] timesArr = shortToByte2(times.shortValue());
        System.arraycopy(timesArr, 0, data, 28, 2);
        //本次输入量 4(Hex) 整型，金额单位（分） ，如 00 01 86 A0，100000 分
        //byte[] gasAmountArr = {(byte) 0x00, (byte) 0x00, (byte) 0x27, (byte) 0x10};
        byte[] gasAmountArr = intToByte4(gasValue.multiply(new BigDecimal(100)).intValue());
        System.arraycopy(gasAmountArr, 0, data, 30, 4); //33
        System.out.println(HexUtils.encodeHexStr(data));
        //计算 MAC 常数 8(Hex) MAC 计算时， 使用的常量， 如 55 86 27 61 68 88 25 45
        //4427567442684234
        byte[] macSalt = {44, 27, 56, 74, 42, 68, 42, 34};
        System.arraycopy(macSalt, 0, data, 34, 8);  //41
        //MAC 4(Hex) MAC 计算结果，如 881C08A0  C210C75F 21A6AEA9  7C02BB1C 07D411EE
        byte[] calculateValue = new byte[29];
        System.arraycopy(data, 5, calculateValue, 0, 29);  //45
        String macStr = calculateMac(HexUtils.encodeHexStr(calculateValue));
        byte[] mac = HexUtils.str2Bcd(macStr);
//        byte[] mac = {(byte) 0x96, (byte) 0xEC, (byte) 0xF7, (byte) 0x07};

        //28A53338  96ECF707
        System.arraycopy(mac, 0, data, 42, 4);  //45
        // 0 - 45
        //CRC 检验 2(Hex)
        crc = HexUtils.toBytes(CRCUtils.getCRC(data));

        System.arraycopy(data, 0, command, 0, 46);
        System.arraycopy(crc, 0, command, 46, 2);
        log.debug("最终生成【充值】指令：" + HexUtils.encodeHexStr(command));
        return HexUtils.encodeHexStr(command);
    }
    public static String createRechargeCommand(JSONObject content){
        return createRechargeCommand(
                content.getString("meterNumber"),
                content.getString("cardId"),
                new BigDecimal(content.getString("payValue")),
                new BigDecimal(content.getString("times"))
        );
    }

    /**
     * 生成结束下发指令
     * @return
     */
    public static String closeConnectionCommand(){
        byte[] command = new byte[12];
        byte[] data = {0x17, 0x68, 0x07, (byte) 0xC0, 0x44, 0x54, 0x55, (byte) 0x4F, 0x46, 0x46};
        //CRC 检验 2(Hex)
        byte[] crc = HexUtils.toBytes(CRCUtils.getCRC(data));
        System.arraycopy(data, 0, command, 0, 10);
        System.arraycopy(crc, 0, command, 10, 2);
        return HexUtils.encodeHexStr(command);
    }

    /**
     * 生成调价指令
     *
     * @param meterId
     * @param cardId
     * @param stair1Price
     * @param stair1Amount
     * @param stair2Price
     * @param stair2Amount
     * @param stair3Price
     * @param cycleStartTime
     * @param stairPriceCycleTime
     * @param priceVersion
     * @return
     */
    public static String createPriceAdjustCommand(String meterId, String cardId,
                                                  BigDecimal stair1Price, BigDecimal stair1Amount,
                                                  BigDecimal stair2Price, BigDecimal stair2Amount,
                                                  BigDecimal stair3Price, String cycleStartTime, BigDecimal stairPriceCycleTime, BigDecimal priceVersion) {
        log.debug("开始构建【调价】指令......");
        log.debug("构建【调价】指令参数, meterId: " + meterId
                + ", cardId:" + cardId
                + ", stair1Price:" + stair1Price.toString()
                + ", stair1Amount:" + stair1Amount.toString()
                + ", stair2Price:" + stair2Price.toString()
                + ", stair2Amount:" + stair2Amount.toString()
                + ", stair3Price:" + stair3Price.toString()
                + ", cycleStartTime:" + cycleStartTime
                + ", stairPriceCycleTime:" + stairPriceCycleTime.toString()
                + ", priceVersion:" + priceVersion.toString());
        byte[] command = new byte[85];
        try {

            //构造调价包
            byte[] data = new byte[83];
            byte[] crc;

            //流量计地址
            data[0] = 0x17;
            //功能码
            data[1] = 0x66;
            //data[2]，版本，默认为0
            data[2] = 0;
            //子功能
            data[3] = (byte) 0xA8;
            //长度
            data[4] = 0x4E;
            //集中器表号 10(BCD) 不足的前面补0，如00 00 00 00 00 00 00 00 00 01
            meterId = String.format("%020d", Long.parseLong(meterId));
            byte[] dtuId = HexUtils.str2Bcd(meterId);
            System.arraycopy(dtuId, 0, data, 5, 10); //14
            //流量计编号 6(BCD) 即卡号，不足的前面补0，如00 00 00 00 00 01,
            cardId = String.format("%012d", Long.parseLong(cardId));
            byte[] cId = HexUtils.str2Bcd(cardId);
            System.arraycopy(cId, 0, data, 15, 6);  //20
            //公司代号 2(BCD) 如  3411  3219
            byte[] companyCode = HexUtils.str2Bcd(COMPANY_CODE);
            System.arraycopy(companyCode, 0, data, 21, 2);
            //备用命令 5(Hex) 后期扩展 27
            //常规燃气价格，相当于第一阶梯价格，单位：分 2(Hex) 如 如价格单位为分，015EH，即 3.5元
            byte[] bStair1Price = intToByte2(stair1Price.multiply(new BigDecimal("100")).intValue());
            System.arraycopy(bStair1Price, 0, data, 28, 2);
            //价格启动状态码
            byte[] priceStartCode = {0x12, 0x12};
            System.arraycopy(priceStartCode, 0, data, 30, 2);
            //时间单位状态码
            byte[] timeUnitStateCode = {0x44, 0x44};
            System.arraycopy(timeUnitStateCode, 0, data, 32, 2);
            //价格启用时间(年月日时)
            //2020 06 29
            //2020
            byte[] priceStartTime = {0x14, 0x7, 0x17, 0x10};
            System.arraycopy(priceStartTime, 0, data, 34, 4);
            //amount1
            byte[] amount1 = intToByte4(stair1Amount.intValue());
            System.arraycopy(amount1, 0, data, 38, 4);
            //price2
            byte[] bStair2Price = intToByte2(stair2Price.multiply(new BigDecimal("100")).intValue());
            System.arraycopy(bStair2Price, 0, data, 42, 2);
            //amount2
            byte[] amount2 = intToByte4(stair2Amount.intValue());
            System.arraycopy(priceStartTime, 0, data, 44, 4);
            //price3
            byte[] bStair3Price = intToByte2(stair3Price.multiply(new BigDecimal("100")).intValue());
            System.arraycopy(bStair3Price, 0, data, 48, 2);
            //价格周期
            byte[] bStairPriceCycleTime = intToByte2((stairPriceCycleTime.intValue()));
            System.arraycopy(bStairPriceCycleTime, 0, data, 50, 2);
            //时长价格方案lenth: 16
            //价格版本号
            byte[] bPriceVersion = intToByte2(priceVersion.intValue());
            System.arraycopy(bPriceVersion, 0, data, 68, 2);
            //价格单位
            byte[] priceUnit = {0x0};
            System.arraycopy(priceUnit, 0, data, 70, 1);

            //计算 MAC 常数 8(Hex) MAC 计算时， 使用的常量， 如 55 86 27 61 68 88 25 45
            //4427567442684234
            byte[] macSalt = {44, 27, 56, 74, 42, 68, 42, 34};
            System.arraycopy(macSalt, 0, data, 71, 8);
            //MAC 4(Hex) MAC 计算结果，如 881C08A0  C210C75F 21A6AEA9  7C02BB1C 07D411EE
            byte[] calculateValue = new byte[66];
            System.arraycopy(data, 5, calculateValue, 0, 66);
            String macStr = calculateMac(HexUtils.encodeHexStr(calculateValue));
            log.debug("获取【调价】mac：" + macStr);
            byte[] mac = HexUtils.str2Bcd(macStr);
//        byte[] mac = {(byte) 0x64, (byte) 0xE5, (byte) 0x46, (byte) 0x40};
            //28A53338  96ECF707
            System.arraycopy(mac, 0, data, 79, 4);
            // 0 - 45
            //CRC 检验 2(Hex)
            String crc1 = CRCUtils.getCRC(data);
            System.out.println("crc: " + crc1);
            crc = HexUtils.toBytes(crc1);

            System.arraycopy(data, 0, command, 0, 83);
            System.arraycopy(crc, 0, command, 83, 2);
            log.debug("最终生成【调价】指令：" + HexUtils.encodeHexStr(command));

        } catch (Exception e) {
            log.debug("生成【调价】指令异常：" + e.getMessage());
        }
        return HexUtils.encodeHexStr(command);
    }
    public static String createPriceAdjustCommand(JSONObject content){
        return createPriceAdjustCommand(
                content.getString("meterNumber"),
                content.getString("cardId"),
                new BigDecimal(content.getString("price1")),
                new BigDecimal(content.getString("gasVolume1")),
                new BigDecimal(content.getString("price2")),
                new BigDecimal(content.getString("gasVolume2")),
                new BigDecimal(content.getString("price3")),
                content.getString("stairStartDate"),
                new BigDecimal(content.getString("stairMonths")),
                new BigDecimal(content.getString("version"))
        );
    }


    /**
     * 生成阀门控制指令
     *
     * @param meterId
     * @param cardId
     * @param valveCommand 0：解除开阀禁止状态，1：关阀且禁止开阀
     * @return
     */
    public static String createValveCommand(String meterId, String cardId, BigDecimal valveCommand) {
        log.debug("开始构建【阀控】指令......");
        byte[] command = new byte[43];
        //构造充值包
        byte[] data = new byte[41];
        byte[] crc;

        //流量计地址
        data[0] = 0x17;
        //功能码
        data[1] = 0x66;
        //data[2]，版本，默认为0
        data[2] = 0;
        //子功能
        data[3] = (byte) 0xA7;
        //长度
        data[4] = 0x24;
        //集中器表号 10(BCD) 不足的前面补0，如00 00 00 00 00 00 00 00 00 01
        meterId = String.format("%020d", Long.parseLong(meterId));
        byte[] dtuId = HexUtils.str2Bcd(meterId);
        System.arraycopy(dtuId, 0, data, 5, 10); //14
        //流量计编号 6(BCD) 即卡号，不足的前面补0，如00 00 00 00 00 01,
        cardId = String.format("%012d", Long.parseLong(cardId));
        byte[] cId = HexUtils.str2Bcd(cardId);
        System.arraycopy(cId, 0, data, 15, 6);  //20
        //公司代号 2(BCD) 如  3411  3219
        byte[] companyCode = HexUtils.str2Bcd(COMPANY_CODE);
        System.arraycopy(companyCode, 0, data, 21, 2);
        //备用命令 5(Hex) 后期扩展 27
        //阀控命令 1(Hex) 00：解除开阀禁止状态，01：关阀且禁止开阀
        byte[] valveCmd = valveCommand.shortValue() == 1 ? new byte[]{0x01} : new byte[]{0x00};
        System.arraycopy(valveCmd, 0, data, 28, 1);
        //计算 MAC 常数 8(Hex) MAC 计算时， 使用的常量， 如 55 86 27 61 68 88 25 45
        //4427567442684234
        byte[] macSalt = {44, 27, 56, 74, 42, 68, 42, 34};
        System.arraycopy(macSalt, 0, data, 29, 8);  //41
        //MAC 4(Hex) MAC 计算结果，如 07D411EE
        byte[] calculateValue = new byte[24];
        System.arraycopy(data, 5, calculateValue, 0, 24);  //45
        String macStr = calculateMac(HexUtils.encodeHexStr(calculateValue));
        //byte[] mac = {(byte) 0x96, (byte) 0xEC, (byte) 0xF7, (byte) 0x07};
        byte[] mac = HexUtils.str2Bcd(macStr);
        //28A53338  96ECF707
        System.arraycopy(mac, 0, data, 37, 4);  //45
        // 0 - 45
        //CRC 检验 2(Hex)
        crc = HexUtils.toBytes(CRCUtils.getCRC(data));

        System.arraycopy(data, 0, command, 0, 41);
        System.arraycopy(crc, 0, command, 41, 2);
        log.debug("最终生成【阀控】指令：" + HexUtils.encodeHexStr(command));
        return HexUtils.encodeHexStr(command);
    }
    public static String createValveCommand(JSONObject content){
        return createValveCommand(
                content.getString("meterNumber"),
                content.getString("cardId"),
                new BigDecimal(content.getString("valveState"))
        );
    }

    /**
     * 生成抄表指令
     *
     * @return
     */
    public static String createMeterReadCommand2(String meterId,String cardId) {
        log.debug("开始构建【抄表】指令......");
        byte[] command = new byte[48];
        //构造抄表包
        byte[] data = new byte[46];
        byte[] crc;

        //流量计地址
        data[0] = 0x17;
        //功能码
        data[1] = 0x66;
        //data[2]，版本，默认为0
        data[2] = 0;
        //子功能
        data[3] = (byte) 0xA6;
        //长度
        data[4] = 0x26;
        //集中器表号 10(BCD) 不足的前面补0，如00 00 00 00 00 00 00 00 00 01
        meterId = String.format("%020d", Long.parseLong(meterId));
        byte[] dtuId = HexUtils.str2Bcd(meterId);
        System.arraycopy(dtuId, 0, data, 5, 10); //14
        //流量计编号 6(BCD) 即卡号，不足的前面补0，如00 00 00 00 00 01,
        if (cardId.length() > 10) {
            cardId = cardId.substring(0, 10);
        }

        cardId = String.format("%012d", Long.parseLong(cardId));
        byte[] cId = HexUtils.str2Bcd(cardId);
        System.arraycopy(cId, 0, data, 15, 6);  //20
        //公司代号 2(BCD) 如  3411  3219
        byte[] companyCode = HexUtils.str2Bcd(COMPANY_CODE);
        System.arraycopy(companyCode, 0, data, 21, 2);
        //备用命令 5(Hex) 后期扩展 27
        //流量计寄存器起始地址
        byte[] timesArr = {(byte) 0xA2, (byte) 0x50};
        System.arraycopy(timesArr, 0, data, 28, 2);
        //读寄存器长度
        byte[] saveLengthArr = {(byte) 0xA0 };
        System.arraycopy(saveLengthArr, 0, data, 30, 1);
        System.out.println(HexUtils.encodeHexStr(data));
        //计算 MAC 常数 8(Hex) MAC 计算时， 使用的常量， 如 55 86 27 61 68 88 25 45
        //4427567442684234
        byte[] macSalt = {44, 27, 56, 74, 42, 68, 42, 34};
        System.arraycopy(macSalt, 0, data, 31, 8);  //41
        //MAC 4(Hex) MAC 计算结果，如 881C08A0  C210C75F 21A6AEA9  7C02BB1C 07D411EE
        byte[] calculateValue = new byte[29];
        System.arraycopy(data, 5, calculateValue, 0, 29);  //45
        String macStr = calculateMac(HexUtils.encodeHexStr(calculateValue));
        byte[] mac = HexUtils.str2Bcd(macStr);
//        byte[] mac = {(byte) 0x96, (byte) 0xEC, (byte) 0xF7, (byte) 0x07};

        //28A53338  96ECF707
        System.arraycopy(mac, 0, data, 39, 4);  //45
        // 0 - 45
        //CRC 检验 2(Hex)
        crc = HexUtils.toBytes(CRCUtils.getCRC(data));

        System.arraycopy(data, 0, command, 0, 43);
        System.arraycopy(crc, 0, command, 43, 2);
        log.debug("最终生成【抄表】指令：" + HexUtils.encodeHexStr(command));
        return HexUtils.encodeHexStr(command);
    }

    public static String createMeterReadCommand(String meterId,String cardId) {
        byte[] command = {0x17, 0x03, 0x02, 0x50, 0x00, 0x50, 0x46, (byte) 0xA9};
        return HexUtils.encodeHexStr(command);
    }

    /**
     * 解析数据
     *
     * @param msg
     * @return
     */
    public static JSONObject decodeMsg(String msg) {
        int msgType = decodeMsgType(msg);
        JSONObject obj = new JSONObject();
        if (msgType == 11 || msgType == 12) {
            //注册包或者心跳包  17A3197F 313233343536373839303100 00000000 17007F7F7F030002 F749
            //                17531905 313831303231323139323700 00000000 1707000000000000 0662
            String meterId = HexUtils.asciiHexStr2Str(msg.substring(8, 8 + 12 * 2));
            obj.put("meterId", meterId);
        }
        return obj;
    }

    /**
     * 解析响应数据
     *
     * @param msg
     * @return
     */
    public static JSONObject decodeAckMsg(String msg) {
        log.debug("开始解析【表端响应】指令......");
        int msgType = decodeMsgType(msg);
        JSONObject obj = new JSONObject();
        obj.put("msgType", msgType);
        if (msgType == 21 || msgType == 31) {
            //充值响应or阀控响应 176600A021000502 00000000012345678901001122334455 09 3411 0000000000
            //0000000A 0001 7955
            String meterId = msg.substring(24, 36);
            String cardId = msg.substring(38, 48);
            int responseCode = Integer.parseInt(msg.substring(48, 50), 16);
            int surplusGas = Integer.parseInt(msg.substring(64, 72), 16);
            int meterTimes = Integer.parseInt(msg.substring(72, 76), 16);
            obj.put("meterId", meterId);
            obj.put("cardId", cardId);
            obj.put("responseCode", responseCode);
            obj.put("surplusGas", surplusGas);
            obj.put("meterTimes", meterTimes);
        } else if(msgType == 51){
            //调价响应
            //17 66 00 A8 1C 00 05 05 00 00 00 00 00 00 00 00 00 01 00 00 00 00 00 01 01 34 11 00 00 00 00 00 00 F1 10
            String meterId = msg.substring(24, 36);
            String cardId = msg.substring(38, 48);
            int responseCode = Integer.parseInt(msg.substring(48, 50), 16);
            obj.put("meterId", meterId);
            obj.put("cardId", cardId);
            obj.put("responseCode", responseCode);
        } else if (msgType == 41) {
            //解析抄表数据
            //1703A040D5F58000000000000000000000000000E100000000000000003FB09FF1762EA6203FB1C612F324580041DF60EA42C0D2DD40D5F90000000000000100002005271611353FB09FF1762EA62000000000800202420001402C00000000000046AFC8002005271111001909021520504561000045F9999A0000201904163300000000000000000000000000000000000000000000000000000000000000000000007B79
            obj = processMeterReadingData(msg);
        }
        log.debug("解析结果: " + obj.toString());
        return obj;
    }

    /**
     * 解析抄表数据
     *
     * @param msg
     * @return
     */
    public static JSONObject processMeterReadingData(String msg) {
        JSONObject jo = new JSONObject();
        //解决科学计数法问题
        NumberFormat nf = java.text.NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        //1703A0 40D5F58000000000000000000000000000E100000000000000003FB09FF1762EA6203FB1C612F324580041DF60EA42C0D2DD40D5F90000000000000100002005271611353FB09FF1762EA62000000000800202420001402C00000000000046AFC8002005271111001909021520504561000045F9999A0000201904163300000000000000000000000000000000000000000000000000000000000000000000007B79
        msg = msg.substring(6);
        //表内剩余金额8(单位: 分)
        jo.put("sumLeftVol", nf.format(Double.longBitsToDouble((Long.valueOf(msg.substring(0, 16), 16))) / 100D));
        //表内累计用气量8
        jo.put("sumUsedVol", nf.format(Double.longBitsToDouble((Long.valueOf(msg.substring(16, 32), 16))) / 100D));
        //当前表内价格2(单位: 分)
        jo.put("currentPrice", Integer.valueOf(msg.substring(32, 36), 16) / 10000D);
        //标况流量
        jo.put("vo", Float.intBitsToFloat(Integer.valueOf(msg.substring(36, 44), 16)));
        //工况流量
        jo.put("vm", Float.intBitsToFloat(Integer.valueOf(msg.substring(44, 52), 16)));
        //标况累积流量
        jo.put("sum", Double.longBitsToDouble((Long.valueOf(msg.substring(52, 68), 16))));
        //工况累计流量
        jo.put("pSum", Double.longBitsToDouble((Long.valueOf(msg.substring(68, 84), 16))));
        //计量温度
        jo.put("t", Float.intBitsToFloat(Integer.valueOf(msg.substring(84, 92), 16)));
        //计量压力
        jo.put("pp", Float.intBitsToFloat(Integer.valueOf(msg.substring(92, 100), 16)));
        //用户卡累计输入量8
        jo.put("sumBuyedVol", nf.format(Double.longBitsToDouble((Long.valueOf(msg.substring(100, 116), 16))) / 100D));
        //状态字2(0001)
        String stateStr = msg.substring(116, 120);
        //报警字2(0000)
        String alarmStr = msg.substring(120, 124);
        //表内时间6
        jo.put("meterTime", msg.substring(124, 136));
        //周期内累积用气量
        //jo.put("cycleSum", Double.longBitsToDouble((Long.valueOf(msg.substring(136, 152), 16))));
        //远传表位置号8(卡号)
        jo.put("cardId", msg.substring(152, 168).substring(6));
        jo.put("userId", msg.substring(152, 168).substring(8));
        //累计购气次数2
        jo.put("sumBuyedCount", Integer.valueOf(msg.substring(168, 172), 16));
        //累计用量8
        jo.put("sumUsedMoney", nf.format(Double.longBitsToDouble((Long.valueOf(msg.substring(172, 188), 16))) / 100D));
        //上次购买量4
        jo.put("lastBuyedVol", nf.format(Float.intBitsToFloat(Integer.valueOf(msg.substring(188, 196), 16)) / 100F));
        //上次充值时间6
        jo.put("lastBuyedTime", msg.substring(196, 208));
        //阀门使能1 0（正常）1（禁止开阀）
        jo.put("valveEnable", Byte.valueOf(msg.substring(252, 254)));
        //价格单位1 0（分）1（厘）
        jo.put("priceUnit", Byte.valueOf(msg.substring(252, 254)));

        //解析状态字(0001)00000001
        //低字节信息
        String low = byteToBitString(new Byte(stateStr.substring(2)));
        jo.put("overdraftState", low.substring(4, 5));
        jo.put("valveState", low.substring(6));
        return jo;
    }

    public static void test() {
        log.debug("开始构建【测试】指令......");
    }


    public static String byteToBitString(byte b) {
        return ""
                + (byte) ((b >> 7) & 0x1) + (byte) ((b >> 6) & 0x1)
                + (byte) ((b >> 5) & 0x1) + (byte) ((b >> 4) & 0x1)
                + (byte) ((b >> 3) & 0x1) + (byte) ((b >> 2) & 0x1)
                + (byte) ((b >> 1) & 0x1) + (byte) ((b >> 0) & 0x1);
    }

    /**
     * 调用后台卡服务计算mac值
     *
     * @param value
     * @return
     */
    public static String calculateMac(String value){
        //接收到的数据是带""号的，需要去掉
        //"6AFF5F8A"
        log.debug("获取 mac 请求参数：" + value);
        try {
            return post(CARD_SERVICE_URL, value, null).substring(1, 9);
        } catch (Exception e) {
            log.debug("异常: 获取 mac 请求参数, " + e.getMessage());
        }
        return null;
    }

    public static String post(String path, String value, String headersStr) {
        try {
            HttpPost postMethod = new HttpPost(path);
            StringEntity se = new StringEntity(value, "UTF-8");
            postMethod.setEntity(se);
            String data;
            if (headersStr != null && !"".equals(headersStr)) {
                JSONObject headers = new JSONObject(headersStr);
                Iterator keys = headers.keys();

                while(keys.hasNext()) {
                    String key = (String)keys.next();
                    data = headers.getString(key);
                    postMethod.setHeader(key, data);
                }
            }

            HttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse response = httpClient.execute(postMethod);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return EntityUtils.toString(response.getEntity(), "UTF8");
            } else {
                data = response.getStatusLine().getReasonPhrase();
                throw new WebException(code, data);
            }
        } catch (RuntimeException var9) {
            throw var9;
        } catch (Exception var10) {
            throw new RuntimeException(var10);
        }
    }

    /**
     * short整数转换为2字节的byte数组
     *
     * @param s short整数
     * @return byte数组
     */
    private static byte[] shortToByte2(int s) {
        byte[] targets = new byte[2];
        targets[0] = (byte) (s >> 8 & 0xFF);
        targets[1] = (byte) (s & 0xFF);
        return targets;
    }

    private static byte[] intToByte4(int i) {
        byte[] targets = new byte[4];
        targets[3] = (byte) (i & 0xFF);
        targets[2] = (byte) (i >> 8 & 0xFF);
        targets[1] = (byte) (i >> 16 & 0xFF);
        targets[0] = (byte) (i >> 24 & 0xFF);
        return targets;
    }

    private static byte[] intToByte2(int i) {
        byte[] targets = new byte[2];
        targets[1] = (byte) (i & 0xFF);
        targets[0] = (byte) (i >> 8 & 0xFF);
        return targets;
    }

    /**
     * 将字节数组转换成整数
     */
    public static int byteArr2Int(byte[] arr) {
        return (arr[0] & 0xff) << 24
                | (arr[1] & 0xff) << 16
                | (arr[2] & 0xff) << 8
                | (arr[3] & 0xff);
    }

    /**
     * 把16进制字符串转换成字节数组
     *
     * @param hex
     * @return byte[]
     */
    public static byte[] hexStringToByte(String hex) {
        int len = (hex.length() / 2);
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; i++) {
            int pos = i * 2;
            result[i] = (byte) (toByte(achar[pos]) << 4 | toByte(achar[pos + 1]));
        }
        return result;
    }

    private static int toByte(char c) {
        byte b = (byte) "0123456789ABCDEF".indexOf(c);
        return b;
    }

    /**
     * 价格启用时间转换(年月日时20072318, 代表2020-07-23日18时)
     *
     * @param date
     * @return
     */
    private static byte[] date2bytes(String date) {
        byte[] resutl = new byte[4];
        for (int i = 0; i < 4; i++) {
            String s = date.substring(i * 2, i * 2 + 2);

        }

        return resutl;
    }

    public static void main(String[] args) {
        System.out.println(decodeMsg("17A31905313930393231333133303800000000001707000000000000DB0E"));

    }
}
