//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.aote.webmeter.module.customize.aodesystem.aes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WXBizMsgCrypt {
    private static final Logger LOGGER = Logger.getLogger(WXBizMsgCrypt.class);
    static Charset CHARSET;
    Base64 base64 = new Base64();
    byte[] aesKey;
    String token;
    String corpId;

    public WXBizMsgCrypt(String token, String encodingAesKey, String corpId) throws AesException {
        if (encodingAesKey.length() != 43) {
            throw new AesException(-40004);
        } else {
            this.token = token;
            this.corpId = corpId;
            this.aesKey = Base64.decodeBase64(encodingAesKey + "=");
        }
    }

    byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[]{(byte)(sourceNumber >> 24 & 255), (byte)(sourceNumber >> 16 & 255), (byte)(sourceNumber >> 8 & 255), (byte)(sourceNumber & 255)};
        return orderBytes;
    }

    int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;

        for(int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 255;
        }

        return sourceNumber;
    }

    String getRandomStr() {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();

        for(int i = 0; i < 16; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }

        return sb.toString();
    }

    String encrypt(String randomStr, String text) throws AesException {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = randomStr.getBytes(CHARSET);
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] corpidBytes = this.corpId.getBytes(CHARSET);
        byteCollector.addBytes(randomStrBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(textBytes);
        byteCollector.addBytes(corpidBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();

        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            return this.base64.encodeToString(encrypted);
        } catch (Exception var14) {
            var14.printStackTrace();
            throw new AesException(-40006);
        }
    }

    String decrypt(String text) throws AesException {
        byte[] original;
        byte[] networkOrder;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, key_spec, iv);
            networkOrder = Base64.decodeBase64(text);
            original = cipher.doFinal(networkOrder);
        } catch (Exception var9) {
            var9.printStackTrace();
            throw new AesException(-40007);
        }

        String xmlContent;
        String from_corpid;
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            from_corpid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        } catch (Exception var8) {
            var8.printStackTrace();
            throw new AesException(-40008);
        }

        if (!from_corpid.equals(this.corpId)) {
            throw new AesException(-40005);
        } else {
            return xmlContent;
        }
    }

    public JSONObject EncryptMsg(String replyMsg, String timeStamp, String nonce) throws AesException {
        String encrypt = this.encrypt(this.getRandomStr(), replyMsg);
        if (timeStamp.equals("")) {
            timeStamp = Long.toString(System.currentTimeMillis());
        }

        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt);
        JSONObject params = new JSONObject();
        params.put("content", encrypt);
        params.put("metaData", XMLParse.generate(encrypt, signature, timeStamp, nonce));
        return params;
    }

    public String DecryptMsg(String msgSignature, String timeStamp, String nonce, String postData) throws AesException {
        LOGGER.debug("wx解密前的密文：" + postData);
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, postData);
        LOGGER.debug("wx解密的signature：" + signature);
        LOGGER.debug("比较的signature：" + msgSignature);
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        } else {
            return this.decrypt(postData);
        }
    }

    public String VerifyURL(String msgSignature, String timeStamp, String nonce, String echoStr) throws AesException {
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, echoStr);
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        } else {
            return this.decrypt(echoStr);
        }
    }

    static {
        CHARSET = StandardCharsets.UTF_8;
    }
}
