//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.aote.webmeter.module.customize.aodesystem.aes;

import com.af.plugins.HttpConnectionPoolUtil;
import com.aote.webmeter.tools.BasicTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.UUID;

public class Tools {
    private static final Logger LOGGER = Logger.getLogger(BasicTools.class);

    public Tools() {
    }

    public static JSONObject post(String url, JSONObject content, JSONObject header) throws Exception {
        String sToken = WebMeterInfo.getString("appSecret");
        String sCorpID = WebMeterInfo.getString("CorpID");
        String sEncodingAESKey = WebMeterInfo.getString("EncodingAESKey");
        String sReqTimeStamp = String.valueOf(System.currentTimeMillis());
        String sReqNonce = UUID.randomUUID().toString();
        SignTempCrypt signTempCrypt = new SignTempCrypt(sToken, sEncodingAESKey, sCorpID);
        LOGGER.debug("加密内容：" + content + "/" + sReqTimeStamp + "/" + sReqNonce + "/" + sCorpID);
        JSONObject encryptJson = signTempCrypt.encrypt(content, sReqTimeStamp, sReqNonce, sCorpID);
        String encrypt = encryptJson.getString("metaData").replace("\n", "");
        LOGGER.debug(encrypt);
        header = SignTempCrypt.getRestHeader(encrypt);
        LOGGER.debug("加密请求头：" + header);
        String body = encryptJson.getString("content");
        LOGGER.debug("加密请求体：" + body);
        JSONObject result = post(url, body, header.toString());
        JSONObject responseHeader = result.getJSONObject("header");
        String responseBody = result.getString("body");
        return decrypt(responseBody,responseHeader);
    }

    public static JSONObject decrypt(String responseBody, JSONObject responseHeader) throws Exception {
        String sToken = WebMeterInfo.getString("appSecret");
        String sCorpID = WebMeterInfo.getString("CorpID");
        String sEncodingAESKey = WebMeterInfo.getString("EncodingAESKey");
        SignTempCrypt signTempCrypt = new SignTempCrypt(sToken, sEncodingAESKey, sCorpID);
        if (responseHeader.has("Msg_signature")) {
            responseHeader.put("msg_signature", responseHeader.getString("Msg_signature"));
            responseHeader.put("timestamp", responseHeader.getString("Timestamp"));
            responseHeader.put("nonce", responseHeader.getString("Nonce"));
        }
        LOGGER.debug("解析前请求头：" + responseHeader);
        LOGGER.debug("解析前请求体：" + responseBody);
        return signTempCrypt.decrypt(responseBody, responseHeader.getString("msg_signature"), responseHeader.getString("timestamp"), responseHeader.getString("nonce"));
    }

    public static JSONObject encrypt(JSONObject content) throws Exception {
        String sToken = WebMeterInfo.getString("appSecret");
        String sCorpID = WebMeterInfo.getString("CorpID");
        String sEncodingAESKey = WebMeterInfo.getString("EncodingAESKey");
        String sReqTimeStamp = String.valueOf(System.currentTimeMillis());
        String sReqNonce = UUID.randomUUID().toString();
        SignTempCrypt signTempCrypt = new SignTempCrypt(sToken, sEncodingAESKey, sCorpID);
        LOGGER.debug("加密内容：" + content + "/" + sReqTimeStamp + "/" + sReqNonce + "/" + sCorpID);
        JSONObject encryptJson = signTempCrypt.encrypt(content, sReqTimeStamp, sReqNonce, sCorpID);
        String encrypt = encryptJson.getString("metaData").replace("\n", "");
        LOGGER.debug(encrypt);
        JSONObject header = SignTempCrypt.getRestHeader(encrypt);
        LOGGER.debug("加密请求头：" + header);
        String body = encryptJson.getString("content");
        LOGGER.debug("加密请求体：" + body);
        JSONObject result = new JSONObject();
        result.put("header", header);
        result.put("content", body);
        return result;
    }

    public static JSONObject post(String path, String value, String header) throws IOException {
        return request(path, value, header, new HttpPost(), HttpConnectionPoolUtil.getHttpClient());
    }

    public static JSONObject request(String path,
                                 String value,
                                 String headersStr,
                                 HttpRequestBase base,
                                 CloseableHttpClient httpClient) throws IOException {
        //配置请求参数
        setRequestConfig(base);
        //设置请求体
        if(base instanceof HttpEntityEnclosingRequestBase) {
            setPostParams((HttpEntityEnclosingRequestBase) base, value);
        }
        //设置请求头
        setHeaders(base,headersStr);
        //设置请求地址
        base.setURI(URI.create(path));
        CloseableHttpResponse response = null;
        JSONObject result = new JSONObject();
        try {
            long begin = System.currentTimeMillis();
            response = httpClient.execute(base, HttpClientContext.create());
            long end = System.currentTimeMillis();
            long time = end - begin;
            String text = "请求接口耗时："+time+"ms";
            if(time >= 500){
                LOGGER.warn(text);
            } else {
                LOGGER.info(text);
            }
            String code = String.valueOf(response.getStatusLine().getStatusCode());
            // 获取数据成功，返回数据
            if (code.startsWith("2")) {
                JSONObject headerObject = new JSONObject();
                Header[] headerArray = response.getAllHeaders();
                for (Header header : headerArray) {
                    headerObject.put(header.getName(), header.getValue());
                }
                result.put("header", headerObject);
                result.put("body", EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8));
            } else {
                result.put("body", response.getStatusLine().getReasonPhrase());
            }
        } finally {
            if (response != null) {
                response.close();
            }
        }
        return result;
    }

    private static void setRequestConfig(HttpRequestBase httpRequestBase){
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectionRequestTimeout(20000)
                .setConnectTimeout(20000)
                .setSocketTimeout(20000).build();
        httpRequestBase.setConfig(requestConfig);
    }

    private static void setPostParams(HttpEntityEnclosingRequestBase base, String params){
        //设置请求体
        if(params != null && !"".equals(params)){
            StringEntity se = new StringEntity(params,StandardCharsets.UTF_8);
            base.setEntity(se);
        }
    }

    private static void setHeaders(HttpRequestBase base,String headersStr) {
        // 设置请求头
        if (headersStr != null && !"".equals(headersStr)) {
            JSONObject headers = new JSONObject(headersStr);
            Iterator<String> keys = headers.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                String val = headers.getString(key);
                base.setHeader(key, val);
            }
        }
    }
}
