//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.aote.webmeter.module.customize.aodesystem.aes;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;

public class SignTempCrypt {
    private static final Logger LOGGER = Logger.getLogger(SignTempCrypt.class);
    private final WXBizMsgCrypt wxBizMsgCrypt;

    public SignTempCrypt(String token, String encodingAesKey, String corpId) throws AesException {
        this.wxBizMsgCrypt = new WXBizMsgCrypt(token, encodingAesKey, corpId);
    }

    public JSONObject encrypt(JSONObject param, String timeStamp, String nonce, String corpId) throws Exception {
        return this.wxBizMsgCrypt.EncryptMsg(param.toString(), timeStamp, nonce);
    }

    public static String getRestBody(String param, String corpId) throws Exception {
        if (StringUtils.isEmpty(param)) {
            throw new Exception("密文xml为空或者不存在");
        } else {
            return toxml(param, "Encrypt");
        }
    }

    public static JSONObject getRestHeader(String param) throws Exception {
        if (StringUtils.isEmpty(param)) {
            throw new Exception("密文xml为空或者不存在");
        } else {
            JSONObject resultObj = new JSONObject();

            try {
                resultObj.put("msg_signature", toxml(param, "MsgSignature"));
                resultObj.put("timestamp", toxml(param, "TimeStamp"));
                resultObj.put("nonce", toxml(param, "Nonce"));
                return resultObj;
            } catch (Exception var3) {
                throw new Exception("xml解析失败", var3);
            }
        }
    }

    public static void main(String[] args) {
        try {
            JSONObject content = getRestHeader("<xml>\n<Encrypt><![CDATA[BmrkEk8bEh64Y0apFpmA0zsVEaLDaqJrU9ieEGJpOmIewFzBg6ZOHdl4IEr0u76uVZ4RzdohHxHeCrMs8XNHByHCMASWtWyptynMNLIuFloKjjjDsuz0huDY6r5Zeupg8Q9A7NLOKmw80kgvzfH/uqqq2y8FBEzR83O3WWeBnfS8cO/uLdTgue/QtVJQYN0IpIS0P7ANDvvdd3JpTsmnrcu8RdHmsG3SkVHq9Jt1iJWar8TXwFiSOzKOVUjCF6VByfdTMIUUhdhKnfSr2eVXxlyHbOJJm4ilYp6DVCZbN+b/k0KL4PyhWacPYNVCzSOhl+ubYOVwBC5Oa5kY+apTWVuumM6eZ6YL3hNUusuZ3JpNbKxARZz41mXCfVPWuoJlRkTdjwBcYJ09bmFq5mFVWzvhGu40arRCC3zJ95IhumMvps9dzp5E+qd+4fSU+fF0IAa2tBe17lRzEtTQaThMFyMXc2XpxrvAWEbt+fCi3M64FcYjBJP7CfRXhtVPrAQJPp3cN1G9MOugy5Bamk3My6BZN4muhhoKpdyKZ8SXfMVqkCMi335Q4ka/D1Tj1EBLPC/DqOBKBl3mnaJ3dGMaVTAIGOkyryfojj2akujyqEoJqxD1lIWh52btzgRnNpGAOaDy+EqbIRnH7f/m3JUuaX/xY4hw22Wlu8d2gSposXymjPrdCHCDXUENASdONC6RSogZ3OvD/Ya/OL2vmlZdYOZTQcKJA5TZWxgOVJwwkLUMBzH0uvngqKlIs5j9uRFnOusfdw/0Q6Ghx0zYjFb/P/K1/ZVNH/1t06cI9RF+Pc0BQ5LCdakUNmmgY80c2gVN+iNEe95GWZ6FfOWg0Yw2MCDpEUPKKVw1IAq0em/J0SoldG1oGPuP5M2YKVP4YjjR]]></Encrypt>\n<MsgSignature><![CDATA[8aecb5df43a868b0a888ca3ac27c2ebee32396a7]]></MsgSignature>\n<TimeStamp>1609121220390</TimeStamp>\n<Nonce><![CDATA[63229ed8-195e-4587-b3a7-797233703e02]]></Nonce>\n</xml>");
            System.out.println(content);
        } catch (Exception var2) {
            var2.printStackTrace();
        }

    }

    public String getRestHeader2(String param) throws Exception {
        if (StringUtils.isEmpty(param)) {
            throw new Exception("密文xml为空或者不存在");
        } else {
            JSONObject restHeader = getRestHeader(param);
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = restHeader.keys();

            while(iterator.hasNext()) {
                String key = (String)iterator.next();
                stringBuilder.append(key);
                stringBuilder.append("=");
                stringBuilder.append(restHeader.get(key));
                if (iterator.hasNext()) {
                    stringBuilder.append("&");
                }
            }

            return stringBuilder.toString();
        }
    }

    public JSONObject decrypt(String respStr, String sign, String timeStamp, String nonce) throws Exception {
        try {
            String sMsg = this.wxBizMsgCrypt.DecryptMsg(sign, timeStamp, nonce, respStr);
            LOGGER.debug("解密响应内容：" + sMsg);
            JSONObject resultobj = new JSONObject(sMsg);
            return resultobj;
        } catch (AesException var7) {
            throw new Exception("验证签名失败", var7);
        }
    }

    public String JsontoXml(String param, String corpId) {
        if (StringUtils.isEmpty(param)) {
            return "";
        } else {
            String sRespData = "<xml><FromUserName><![CDATA[corpId]]></FromUserName><Content><![CDATA[reqstr]]></Content><AgentID>128</AgentID></xml>";
            sRespData = sRespData.replaceAll("corpId", corpId);
            sRespData = sRespData.replaceAll("reqstr", param);
            return sRespData;
        }
    }

    public static String toxml(String param, String key) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        StringReader sr = new StringReader(param);
        InputSource is = new InputSource(sr);
        Document document = db.parse(is);
        Element root = document.getDocumentElement();
        NodeList nodelist1 = root.getElementsByTagName(key);
        return nodelist1.item(0).getTextContent();
    }
}
