/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.iot.device;

import cn.hutool.core.util.NumberUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DeviceHelper {
    private static final Map<String, Map<String, String>> countMap = new HashMap<String, Map<String, String>>(3);

    public static String getSQL(String tableName) {
        Map<String, String> dictionary = countMap.get(tableName.split(" ")[0]);
        StringBuilder builder = new StringBuilder();
        dictionary.forEach((key, value) -> builder.append((String)key).append(" as ").append((String)value).append(","));
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static JSONArray formatDeviceUploadCountData(JSONArray data) {
        JSONArray result = new JSONArray();
        for (Object item : data) {
            JSONObject dataItem = (JSONObject)item;
            for (String key : dataItem.keySet()) {
                if (key.equals("date")) continue;
                JSONObject realData = new JSONObject();
                Object value = dataItem.get(key);
                try {
                    value = NumberUtil.parseDouble((String)value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                realData.put("name", (Object)key);
                realData.put("date", (Object)dataItem.getString("date"));
                realData.put("value", value);
                result.put((Object)realData);
            }
        }
        return result;
    }

    public static Map<String, Boolean> legendStyle(String tableName) {
        Map<String, String> dictionary = countMap.get(tableName.split(" ")[0]);
        LinkedHashMap<String, Boolean> legendStyle = new LinkedHashMap<String, Boolean>();
        int[] i = new int[]{0};
        dictionary.forEach((key, value) -> {
            legendStyle.put((String)value, i[0] <= 2);
            i[0] = i[0] + 1;
        });
        return legendStyle;
    }

    static {
        LinkedHashMap<String, String> t_pressure_monitor_read_map = new LinkedHashMap<String, String>(10);
        t_pressure_monitor_read_map.put("count(0)", "\u4e0a\u62a5\u6b21\u6570");
        t_pressure_monitor_read_map.put("max(f_hsp)", "\u7ba1\u9053\u6c14\u4f53\u76f8\u5bf9\u538b\u529b");
        t_pressure_monitor_read_map.put("max(f_hst)", "\u7ba1\u9053\u6c14\u4f53\u6e29\u5ea6");
        t_pressure_monitor_read_map.put("min(f_hsdy)", "\u4f20\u611f\u5668\u7535\u6c60\u7535\u538b");
        t_pressure_monitor_read_map.put("min(f_hsdl)", "\u4f20\u611f\u5668\u7535\u6c60\u7535\u91cf");
        t_pressure_monitor_read_map.put("max(f_hstv)", "\u592a\u9633\u80fd\u7535\u6c60\u7535\u538b");
        t_pressure_monitor_read_map.put("min(f_hsta)", "\u592a\u9633\u80fd\u7535\u6c60\u7535\u6d41");
        t_pressure_monitor_read_map.put("max(f_hstt)", "\u592a\u9633\u80fd\u7535\u6c60\u6e29\u5ea6");
        t_pressure_monitor_read_map.put("min(f_hsdv)", "\u76f4\u6d41\u4f9b\u7535\u7535\u6c60\u7535\u538b");
        t_pressure_monitor_read_map.put("min(f_hsda)", "\u76f4\u6d41\u4f9b\u7535\u7535\u6c60\u7535\u6d41");
        t_pressure_monitor_read_map.put("max(f_hsdt)", "\u76f4\u6d41\u4f9b\u7535\u7535\u6c60\u6e29\u5ea6");
        countMap.put("t_pressure_monitor_read", t_pressure_monitor_read_map);
        LinkedHashMap<String, String> t_pressure_transmitters_read_map = new LinkedHashMap<String, String>(8);
        t_pressure_transmitters_read_map.put("count(0)", "\u4e0a\u62a5\u6b21\u6570");
        t_pressure_transmitters_read_map.put("max(flowmeterpressure)", "\u538b\u529b\u503c");
        t_pressure_transmitters_read_map.put("max(flowmetertemperature)", "\u6e29\u5ea6\u503c");
        t_pressure_transmitters_read_map.put("min(f_signal)", "\u4fe1\u53f7\u5f3a\u5ea6");
        t_pressure_transmitters_read_map.put("min(f_electricity)", "\u7535\u91cf");
        t_pressure_transmitters_read_map.put("max(f_highpressur)", "\u538b\u529b\u91cf\u7a0b\u9ad8");
        t_pressure_transmitters_read_map.put("min(f_lowpressure)", "\u538b\u529b\u91cf\u7a0b\u4f4e");
        t_pressure_transmitters_read_map.put("max(f_hightemperature)", "\u6e29\u5ea6\u91cf\u7a0b\u9ad8");
        t_pressure_transmitters_read_map.put("min(f_lowtemperature)", "\u6e29\u5ea6\u91cf\u7a0b\u4f4e");
        countMap.put("t_pressure_transmitters_read", t_pressure_transmitters_read_map);
        LinkedHashMap<String, String> t_wireless_detector_read_map = new LinkedHashMap<String, String>(1);
        t_wireless_detector_read_map.put("count(0)", "\u4e0a\u62a5\u6b21\u6570");
        countMap.put("t_wireless_detector_read", t_wireless_detector_read_map);
    }
}

