/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.apply.timer;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Profile(value={"prod"})
@Transactional
public class UpdateWorkflowTaskStatisticsSchedule {
    @Autowired
    SqlServer sqlServer;
    @Autowired
    EntityServer entityServer;
    private JSONArray applyList;
    private String currentTime;
    private Map<Integer, List<JSONObject>> applyStepMap;

    @Scheduled(cron="0 0 * * * ?")
    public void doJob() throws Exception {
        this.applyList = this.sqlServer.query("getApply", "", Integer.valueOf(0));
        JSONArray applyStepList = this.sqlServer.query("getApplyStep", "", Integer.valueOf(0));
        this.applyStepMap = new HashMap<Integer, List<JSONObject>>(256);
        for (Object stepObject : applyStepList) {
            JSONObject step = (JSONObject)stepObject;
            int applyId = step.getInt("apply_id");
            List list = this.applyStepMap.computeIfAbsent(applyId, k -> new ArrayList(8));
            list.add(step);
        }
        this.currentTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
        this.updateEmployeeTaskStatistics();
        this.updateEntryStatistics("process");
        this.updateEntryStatistics("project");
    }

    public void updateEntryStatistics(String entryName) throws Exception {
        String keyName = entryName + "_name";
        HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>(128);
        block0: for (Object applyObject : this.applyList) {
            JSONObject apply = (JSONObject)applyObject;
            JSONObject entryStatisticsData = resultMap.computeIfAbsent(apply.getString(keyName), k -> {
                JSONObject data = new JSONObject();
                data.put("f_" + keyName, (Object)apply.getString(keyName));
                data.put("f_progress_task_num", 0);
                data.put("f_overdue_num", 0);
                data.put("f_total_tasks", 0);
                data.put("f_completed_tasks_num", 0);
                data.put("f_update_time", (Object)this.currentTime);
                return data;
            });
            this.jsonObjectKeyIncrement("f_total_tasks", entryStatisticsData);
            if (apply.getInt("state") == 1) {
                this.jsonObjectKeyIncrement("f_completed_tasks_num", entryStatisticsData);
            }
            if (apply.getInt("state") == 1) continue;
            this.jsonObjectKeyIncrement("f_progress_task_num", entryStatisticsData);
            List<JSONObject> stepList = this.applyStepMap.get(apply.getInt("id"));
            for (JSONObject step : stepList) {
                if (step.getInt("step_id") != apply.getInt("step_id") || !this.isTaskOverdue(step)) continue;
                this.jsonObjectKeyIncrement("f_overdue_num", entryStatisticsData);
                continue block0;
            }
        }
        for (Map.Entry entry : resultMap.entrySet()) {
            this.entityServer.partialSave("t_apply_" + entryName + "_statistics", (JSONObject)entry.getValue());
        }
    }

    public void updateEmployeeTaskStatistics() throws Exception {
        JSONArray employeeList = this.sqlServer.query("getAllEmployee", "");
        for (Object e : employeeList) {
            JSONObject employee = (JSONObject)e;
            String employeeName = employee.getString("f_employee_name");
            int todoNum = 0;
            int overdueNum = 0;
            int totalTasks = 0;
            int completedTasksNum = 0;
            for (Object applyObject : this.applyList) {
                JSONObject apply = (JSONObject)applyObject;
                List<JSONObject> stepList = this.applyStepMap.get(apply.getInt("id"));
                if (stepList == null) continue;
                boolean isCompleted = false;
                boolean isJoinIn = false;
                boolean isTimeout = false;
                stepList.sort(Comparator.comparingInt(o -> o.getInt("step_id")));
                for (JSONObject step : stepList) {
                    if (!step.getString("handler").contains(employeeName)) continue;
                    if (apply.getInt("state") != 1 && apply.getInt("step_id") == step.getInt("step_id")) {
                        ++todoNum;
                    }
                    if (apply.getInt("state") != 1 && apply.getInt("step_id") == step.getInt("step_id")) {
                        isTimeout = this.isTaskOverdue(step);
                    }
                    if (!isCompleted && apply.getInt("state") == 1) {
                        isCompleted = true;
                    }
                    if (isJoinIn) continue;
                    isJoinIn = true;
                }
                if (isCompleted) {
                    ++completedTasksNum;
                }
                if (isJoinIn) {
                    ++totalTasks;
                }
                if (!isTimeout) continue;
                ++overdueNum;
            }
            employee.put("f_todo_num", todoNum);
            employee.put("f_overdue_num", overdueNum);
            employee.put("f_overdue_rate", Math.round((double)overdueNum / (double)todoNum * 100.0));
            employee.put("f_total_tasks", totalTasks);
            employee.put("f_completed_tasks_num", completedTasksNum);
            employee.put("f_update_time", (Object)this.currentTime);
            this.entityServer.partialSave("t_apply_employee_task_statistics", employee);
        }
    }

    private void jsonObjectKeyIncrement(String key, JSONObject o) {
        o.put(key, o.optInt(key) + 1);
    }

    private boolean isTaskOverdue(JSONObject step) {
        String deadline = step.optString("deadline");
        String submitDate = step.optString("step_date");
        return (submitDate.isEmpty() ? this.currentTime : submitDate).compareTo(deadline) > 0;
    }
}

