/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.alibaba.druid.support.json.JSONUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Component
@Path(value="file")
public class FileUploadService {
    private static final Logger LOGGER = Logger.getLogger(FileUploadService.class);
    private static final String TICKET_IMAGES_PATH = "C:\\testImageUpload";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    public String uploadImage(@FormDataParam(value="avatar") InputStream fileInputStream, @FormDataParam(value="avatar") FormDataContentDisposition disposition) {
        Map parameters = disposition.getParameters();
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formatDate = sdf.format(date);
        String path = "C:\\testImageUpload\\" + formatDate;
        File fileDir = new File(path);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        String originalFileName = disposition.getFileName();
        int i = originalFileName.lastIndexOf(".");
        originalFileName = originalFileName.substring(i, originalFileName.length());
        String fileNewName = uuid + originalFileName;
        String destination = path + "\\" + fileNewName;
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(destination);
            byte[] buff = new byte[4096];
            int len = 0;
            while ((len = fileInputStream.read(buff)) != -1) {
                ((OutputStream)os).write(buff, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", fileNewName);
        result.put("url", destination);
        return JSONUtils.toJSONString(result);
    }
}

