package com.aote.webmeter.module.ticket;

import com.af.plugins.JsonTools;
import com.alibaba.fastjson.JSON;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * 调用钉钉工单通知群接口，实现工单发起、加急、取消后的钉钉群信息提醒
 */

public class SendDingMsg {

    // 开关，控制是否向备用群中发消息
    private static boolean switcher = false;
    // 等待5分钟后还原开关状态
    private static long targetTime = 0L;
    private final Map<Integer, String> categoryMap = new HashMap<>();
    private final String URL = "https://oapi.dingtalk.com/robot/send?" +
            "access_token=4eed41cbe4d7870d12de8abc4e47d2b623add1434a85e4e567132cbd992d6b84";
    private final String URL_STANDBY = "https://oapi.dingtalk.com/robot/send?" +
            "access_token=29a592fff807e86384e4a1207d0e9d119a92726983ef3f2f5c8c4b7cfac571e1";

    /**
     * 调用钉钉工单通知群实现方法
     *
     * @param serialNum 工单序列号
     * @param date      当前日期
     * @param name      提交人姓名
     * @param category  工单类型
     * @param desc      工单问题描述
     * @param type      0 新增，1 加急，2 关闭未接单，3 关闭已接单
     * @param worker    当前负责人
     * @return 返回状态码以及msg
     */
    public String send(String serialNum, String date, String name, String category,
                       String desc, Integer type, String worker) {
        // 判断开关状态，决定向哪个接口调用
        String url;
        if (!switcher) {
            url = URL;
        } else {
            url = URL_STANDBY;
        }

        // 格式化日期显示
        date = date.substring(0, 19);
        date = date.replaceFirst("-", "年");
        date = date.replaceFirst("-", "月");

        Map<String, Object> params = new HashMap<>();
        params.put("msgtype", "markdown");

        Map<String, Object> markdown = new HashMap<>();


        // 不同类型的操作，发送不同模板的信息
        switch (type) {
            case 0:
                markdown.put("title", "新工单");
                markdown.put("text", "# 新提交工单 \n ### 工单编号：" + serialNum + " \n #### 于" + date + " \n #### 由客户：" +
                        name + "创建, 请及时响应 \n #### 工单类型：" + category + "  \n\n > " + desc);
                break;
            case 1:
                markdown.put("title", "工单加急");
                markdown.put("text", "# 工单加急提醒 \n ### 工单编号：" + serialNum + " \n #### 于" + date + " \n #### 由客户：" +
                        name + "创建, 请及时响应 \n #### 工单类型：" + category + "  \n\n > " + desc);
                break;
            case 2:
                markdown.put("title", "工单取消");
                markdown.put("text", "# 工单取消提醒 \n ### 工单编号：" + serialNum + " \n #### 于" + date + " \n #### 由客户：" +
                        name + "撤销了请求 \n #### 该工单当前负责人：" + worker + "  \n\n > ");
                break;
            case 3:
                markdown.put("title", "工单取消");
                markdown.put("text", "# 工单取消提醒 \n ### 工单编号：" + serialNum + " \n #### 于" + date + " \n #### 由客户：" +
                        name + "撤销了请求 \n #### 该工单还未被应答 \n\n > ");
                break;
        }


        params.put("markdown", markdown);

        Map<String, Object> at = new HashMap<>();

        //如果是取消工单就不@所有人
        if (type == 2 || type == 3) {
            at.put("isAtAll", false);
        } else {
            at.put("isAtAll", true);
        }

        params.put("at", at);
        String json = JSON.toJSONString(params);

        CloseableHttpClient httpClient = HttpClients.createDefault();

        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setEntity(new StringEntity(json, "UTF-8"));

        CloseableHttpResponse response = null;
        String responseContent = "";

        try {
            response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();
            responseContent = EntityUtils.toString(entity);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        JSONObject jsonObject = JsonTools.convertToJson(responseContent);
        int errcode = (int) jsonObject.get("errcode");

        long now = System.currentTimeMillis();
        if (now > targetTime) {
            switcher = false;
        }

        if (errcode != 0) {
            // 发送失败
            switcher = true;
            // 5分钟后
            targetTime = now + (5 * 60 * 1000);
            send(serialNum, date, name, category, desc, type, worker);
        }

        return responseContent;
    }
}
