package com.aote.webmeter.module.ticket;

import com.aote.redis.RedisUtil;
import org.json.JSONArray;

import javax.swing.*;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicInteger;

public class GetNumberTools {
    private final RedisUtil redisUtil = RedisUtil.getInstance();
    private static final String key = "TicketNumber";

    public String getId(){
        AtomicInteger number = new AtomicInteger();
        redisUtil.lock(key, () -> {
            Object numObj = redisUtil.get(key);
            if(numObj != null){
                number.set(Integer.parseInt(numObj.toString()));
            } else {
                number.set(1);
            }
            // 取出值后，加1
            redisUtil.set(key, number.intValue() +1);
        });
        DecimalFormat df = new DecimalFormat("000");
        return df.format(number.intValue());
    }

}
