package com.aote.webmeter.module.iot.device;

import cn.hutool.core.util.NumberUtil;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * IOT-设备模块帮助类
 */
public class DeviceHelper {

    private static final Map<String, Map<String, String>> countMap;

    static {
        countMap = new HashMap<>(3);
        Map<String, String> t_pressure_monitor_read_map = new LinkedHashMap<>(10);
        t_pressure_monitor_read_map.put("count(0)", "上报次数");
        t_pressure_monitor_read_map.put("max(f_hsp)", "管道气体相对压力");
        t_pressure_monitor_read_map.put("max(f_hst)", "管道气体温度");
        t_pressure_monitor_read_map.put("min(f_hsdy)", "传感器电池电压");
        t_pressure_monitor_read_map.put("min(f_hsdl)", "传感器电池电量");
        t_pressure_monitor_read_map.put("max(f_hstv)", "太阳能电池电压");
        t_pressure_monitor_read_map.put("min(f_hsta)", "太阳能电池电流");
        t_pressure_monitor_read_map.put("max(f_hstt)", "太阳能电池温度");
        t_pressure_monitor_read_map.put("min(f_hsdv)", "直流供电电池电压");
        t_pressure_monitor_read_map.put("min(f_hsda)", "直流供电电池电流");
        t_pressure_monitor_read_map.put("max(f_hsdt)", "直流供电电池温度");
        countMap.put("t_pressure_monitor_read", t_pressure_monitor_read_map);

        Map<String, String> t_pressure_transmitters_read_map = new LinkedHashMap<>(8);
        t_pressure_transmitters_read_map.put("count(0)", "上报次数");
        t_pressure_transmitters_read_map.put("max(flowmeterpressure)", "压力值");
        t_pressure_transmitters_read_map.put("max(flowmetertemperature)", "温度值");
        t_pressure_transmitters_read_map.put("min(f_signal)", "信号强度");
        t_pressure_transmitters_read_map.put("min(f_electricity)", "电量");
        t_pressure_transmitters_read_map.put("max(f_highpressur)", "压力量程高");
        t_pressure_transmitters_read_map.put("min(f_lowpressure)", "压力量程低");
        t_pressure_transmitters_read_map.put("max(f_hightemperature)", "温度量程高");
        t_pressure_transmitters_read_map.put("min(f_lowtemperature)", "温度量程低");
        countMap.put("t_pressure_transmitters_read", t_pressure_transmitters_read_map);

        Map<String, String> t_wireless_detector_read_map = new LinkedHashMap<>(1);
        t_wireless_detector_read_map.put("count(0)", "上报次数");
        countMap.put("t_wireless_detector_read", t_wireless_detector_read_map);
    }


    public static String getSQL(String tableName) {
        Map<String, String> dictionary = countMap.get(tableName.split(" ")[0]);
        StringBuilder builder = new StringBuilder();
        dictionary.forEach((key, value) -> builder.append(key).append(" as ").append(value).append(","));
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    /**
     * 格式化图表统计信息
     *
     * @param data 原始数据
     * @return 组织后数据
     */
    public static JSONArray formatDeviceUploadCountData(JSONArray data) {
        JSONArray result = new JSONArray();
        for (Object item : data) {
            JSONObject dataItem = (JSONObject) item;
            for (String key : dataItem.keySet()) {
                if (!key.equals("date")) {
                    JSONObject realData = new JSONObject();
                    Object value = dataItem.get(key);
                    try {
                        value = NumberUtil.parseDouble(value.toString());
                    } catch (Exception ignored) {
                    }
                    realData.put("name", key);
                    realData.put("date", dataItem.getString("date"));
                    realData.put("value", value);
                    result.put(realData);
                }
            }
        }
        return result;
    }

    /**
     * 返回图例
     *
     * @param tableName 表名
     * @return 图例
     */
    public static Map<String, Boolean> legendStyle(String tableName) {
        Map<String, String> dictionary = countMap.get(tableName.split(" ")[0]);
        Map<String, Boolean> legendStyle = new LinkedHashMap<>();
        final int[] i = {0};
        dictionary.forEach((key, value) -> {
            legendStyle.put(value, i[0] <= 2);
            i[0]++;
        });
        return legendStyle;
    }
}
