package com.aote.webmeter.module.foreignaid;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class GetUrlTools {
    private static final Logger LOGGER = Logger.getLogger(GetUrlTools.class);

    public JSONObject checkUrlByGet(String url){
        try {
            // GETMethod
            HttpGet getMethod = new HttpGet(url);
            //设置超时时间
            RequestConfig requestConfig = RequestConfig.custom()
                    .setConnectionRequestTimeout(3000)
                    .setConnectTimeout(3000)
                    .setSocketTimeout(3000).build();
            getMethod.setConfig(requestConfig);
            // 发送Get请求
            HttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse response = httpClient.execute(getMethod);
            int code = response.getStatusLine().getStatusCode();

            // 获取数据成功，返回数据
            if (code == 200) {
                return new JSONObject("{status: 200, data: \"服务访问成功\"}");
            } else {
                String data = response.getStatusLine().getReasonPhrase();
                // 返回错误码
                return new JSONObject("{status: "+ code + ", data: '" + data + "'}");
            }
        } catch (Exception e) {
            return new JSONObject("{status: 500, data: \"服务访问失败\"}");
        }
    }
}
