package com.aote.webmeter.module.apply.timer;

import com.aote.sql.SqlServer;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

// 定时设置工作流任务逾期状态
@Component
@Profile("prod")
public class UpdateWorkflowTaskOverdueSchedule {

    @Autowired
    SqlServer sqlServer;

    @Scheduled(cron = "0 10 * * * ?")
    @Transactional
    public void doJob() {
        sqlServer.run(sqlServer.getSQL("updateApplyOverdueState", new JSONObject()));
    }
}
