package com.aote.webmeter.module.apply.timer;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.Set;

// 定时从 OA 获取数据，创建项目周报流程
@Component
@Profile("prod")
@Transactional
public class CreateProjectWeeklyProcessSchedule {

    private static final String OA_URL = "http://121.36.59.193:8081/oa-1.0.2";

    private static final String WORKFLOW_DEFINE_NAME = "项目周报流程配置";

    @Autowired
    SqlServer sqlServer;
    @Autowired
    LogicServer logicServer;

    @Scheduled(cron = "0 0 8 ? * 5")
    public void doJob() throws Exception {
        JSONObject data = new JSONObject();
        data.put("condition", " 1=1  and f_projectstep = '实施中'");
        JSONObject params = new JSONObject();
        params.put("data", data);
//        从 OA 获取数据
        String resultString = RestTools.post(OA_URL + "/rs/sql/项目信息", params);
        if (resultString != null) {
            JSONArray resultArray = JsonTools.parseArray(resultString);
//            当天日期，拼接到任务名称中
            String date = DateTools.format(DateTools.getNow2(), "yyyyMMdd");
//            获取工作流定义数据主键 id
            JSONObject logicParam = new JSONObject();
            logicParam.put("a_f_workflow_define_name", WORKFLOW_DEFINE_NAME);
            String workflowDefineId = logicServer.run("initApplyWorkFlowDefineId", logicParam).toString();
//            获取流程定义数据
            JSONObject getDefineLogicParam = new JSONObject();
            getDefineLogicParam.put("processName", WORKFLOW_DEFINE_NAME);
            Object workflowDefine = sqlServer.query("getWorkflowDefineByName", getDefineLogicParam, 1);
//            重复数据不插入
            Set<String> itemSet = new HashSet<>(64);
            for (Object obj : resultArray) {
//                每一条数据
                JSONObject row = (JSONObject) obj;
//                项目经理名字
                String pm = row.optString("f_projectadmin");
//                项目名称
                String projectName = row.optString("cust_name");
                if (!pm.isEmpty() && !projectName.isEmpty() && !itemSet.contains(projectName + pm)) {
//                    新增
                    JSONObject createWorkflowTaskLogicParam = new JSONObject();
                    createWorkflowTaskLogicParam.put("taskName", date + "-项目周报");
                    createWorkflowTaskLogicParam.put("projectName", projectName);
                    createWorkflowTaskLogicParam.put("processName", WORKFLOW_DEFINE_NAME);
                    createWorkflowTaskLogicParam.put("handler", pm);
                    createWorkflowTaskLogicParam.put("workflowDefineId", workflowDefineId);
                    createWorkflowTaskLogicParam.put("workflowDefine", workflowDefine);
                    logicServer.run("createWorkflowTask", createWorkflowTaskLogicParam);
                    itemSet.add(projectName + pm);
                }
            }
        }
    }

}
