package com.aote.rs;

import com.alibaba.druid.support.json.JSONUtils;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Component
@Path("file")
public class FileUploadService {
    private static final Logger LOGGER = Logger.getLogger(FileUploadService.class);

    private static final String TICKET_IMAGES_PATH = "C:\\testImageUpload";

    /**
     * 文件上传
     *
     * @param fileInputStream
     * @param disposition
     * @return
     */
    @POST
    @Path("/upload")
    @Consumes(MediaType.MULTIPART_FORM_DATA)
    public String uploadImage(@FormDataParam("avatar") InputStream fileInputStream,
                              @FormDataParam("avatar") FormDataContentDisposition disposition) {
        Map<String, String> parameters = disposition.getParameters();
        //获取当前日期，生成UUID，最终路径为，TICKET_IMAGES_PATH\yyyyMMdd\UUID + 后缀名
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formatDate = sdf.format(date);
        String path = TICKET_IMAGES_PATH + "\\" + formatDate;

        File fileDir = new File(path);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }

        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        String originalFileName = disposition.getFileName();
        int i = originalFileName.lastIndexOf(".");
        originalFileName = originalFileName.substring(i, originalFileName.length());
        String fileNewName = uuid + originalFileName;
        String destination = path + "\\" + fileNewName;

        //开始写数据
        OutputStream os = null;

        try {
            os = new FileOutputStream(destination);
            byte[] buff = new byte[1024 * 4];
            int len = 0;

            while ((len = fileInputStream.read(buff)) != -1) {
                os.write(buff, 0, len);
            }

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (os != null) {
                    os.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        //定义返回结果
        Map<String, String> result = new HashMap<>();
        result.put("name", fileNewName);
        result.put("url", destination);

        return JSONUtils.toJSONString(result);
    }
}
