package com.aote.webmeter.tools.iot;

import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.enums.TelecomApiEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.iotplatform.client.NorthApiClient;
import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.ClientInfo;

/**
 * 电信IOT平台 获取应用信息
 * @author Mr.river
 */
public class NorthApiClientTools {

	/**
	 * 获取应用信息
	 * @return 应用信息
	 */
	public static NorthApiClient getNorthApiClient() {
		//新建对象NorthApiClient
	    NorthApiClient client = new NorthApiClient();
		//初始化ClientInfo
	    ClientInfo ci = new ClientInfo();
	    ci.setAppId(WebMeterInfo.getString("telecomAPIKey"));
	    ci.setSecret(WebMeterInfo.getString("telecomSecret"));
	    ci.setPlatformIp(TelecomApiEnum.BASE_URL.getValue());
	    ci.setPlatformPort(TelecomApiEnum.BASE_PORT.getValue());
		try {
			//证书配置
			client.setClientInfo(ci);
			client.initSSLConfig();
		} catch (NorthApiException e) {
			throw new WebmeterException(e);
		}
		return client;
	}
}
