package com.aote.webmeter.tools.iot;

import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.exception.WebmeterException;
import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.ModifyDeviceInforInDTO;
import com.iotplatform.client.dto.RegDirectDeviceInDTO2;
import com.iotplatform.client.dto.RegDirectDeviceOutDTO;
import com.iotplatform.client.invokeapi.DeviceManagement;

/**
 * 电信IOT平台设备管理工具
 * @author Mr.river
 */
public class DeviceManagementTools {

	/**
	 * 错误码：设备已被绑定
	 */
	private static final String DEVICE_BINDED_1 = "100416";
	private static final String DEVICE_BINDED_2 = "100426";
	/**
	 * 错误码：设备已被解绑
	 */
	private static final String DEVICE_CANCEL_BINDED_1 = "100403";
	private static final String DEVICE_CANCEL_BINDED_2 = "100418";

	/**
	 * 注册设备
	 * @param nodeId 模组号，即IMEI
	 * @return device_id
	 */
    public String regDevice(String nodeId) {
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
		RegDirectDeviceInDTO2 rabid = new RegDirectDeviceInDTO2();
		//15位IMEI号
        rabid.setNodeId(nodeId);
        rabid.setVerifyCode(nodeId);
        rabid.setTimeout(0);
        RegDirectDeviceOutDTO radded;
        try {
            String authToken = AuthenticationTools.getAuthToken();
            radded = dm.regDirectDevice(
            		rabid,
					WebMeterInfo.getString("telecomAPIKey"),
					authToken
			);
        } catch (NorthApiException e) {
			String errorCode = e.getError_code();
        	if(DEVICE_BINDED_1.equals(errorCode) || DEVICE_BINDED_2.equals(errorCode)){
        		return "设备已被注册";
			}
            throw new WebmeterException(e);
        }
        return radded.getDeviceId();
	}

	/**
	 * 修改设备信息
	 * @param deviceId device_id，设备ID
	 * @param name 设备名
	 * @return 执行结果
	 */
	public int modifyDeviceInfo(String deviceId, String name) {
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
		ModifyDeviceInforInDTO maid = new ModifyDeviceInforInDTO();
        maid.setName(name);
		maid.setManufacturerId(WebMeterInfo.getString("manuFacturerId"));
		maid.setManufacturerName(WebMeterInfo.getString("manuFacturerName"));
		maid.setDeviceType(WebMeterInfo.getString("deviceType"));
		maid.setModel(WebMeterInfo.getString("meterModel"));
        maid.setProtocolType("CoAP");
        try {
			dm.modifyDeviceInfo(
					maid,
					deviceId,
					WebMeterInfo.getString("telecomAPIKey"),
					AuthenticationTools.getAuthToken()
			);
			return 0;
		} catch (NorthApiException e) {
            throw new WebmeterException(e);
		}
	}

	/**
	 * 注销设备
	 * @param deviceId device_id，设备ID
	 * @return 执行结果
	 */
	public int cancelDevice(String deviceId){
		DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
		try {
			String authToken = AuthenticationTools.getAuthToken();
			dm.deleteDirectDevice(
					deviceId,
					null,
					WebMeterInfo.getString("telecomAPIKey"),
					authToken
			);
			return 0;
		} catch (NorthApiException e) {
			String errorCode = e.getError_code();
			if(DEVICE_CANCEL_BINDED_1.equals(errorCode) || DEVICE_CANCEL_BINDED_2.equals(errorCode)){
				return 0;
			}
			throw new WebmeterException(e);
		}
	}
}













