package com.aote.webmeter.module.xianfeng;

import com.af.plugins.DateTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class XianFengNewSystemTools {

    static String key;
    static String merchantId;

    static final Map<String, HashMap.SimpleEntry<String, String>> ALARM_MAP = new HashMap<>(20);

    static {
        WebMeterInfo.setModuleName("XianFengNewSystem");
        key = WebMeterInfo.getString("key");
        merchantId = WebMeterInfo.getString("merchantId");

        initAlarmMap();
    }

    private static void initAlarmMap() {
        ALARM_MAP.put("0001H", new AbstractMap.SimpleEntry<>("死表", "表具多天不⽤⽓，阀⻔⾃动关闭，可按键打开阀⻔"));
        ALARM_MAP.put("0003H", new AbstractMap.SimpleEntry<>("外部检测到异常", "检测到表具可能发生泄漏、打开罩壳、表具倾斜，⾃动关闭阀⻔等情况"));
        ALARM_MAP.put("0004H", new AbstractMap.SimpleEntry<>("电池失压", "电池出现失压，需及时更换电池"));
        ALARM_MAP.put("0006H", new AbstractMap.SimpleEntry<>("流量超限", "表具流量超过最⼤设置值"));
        ALARM_MAP.put("0007H", new AbstractMap.SimpleEntry<>("电池⽋压", "电池出现⽋压，需及时更换电池"));
        ALARM_MAP.put("0008H", new AbstractMap.SimpleEntry<>("单管", "计量单元发⽣异常，⽆法正常记量，阀⻔⾃动关闭"));
        ALARM_MAP.put("0009H", new AbstractMap.SimpleEntry<>("强磁⼲扰", "表具检测到外部有强磁⼲扰，阀⻔⾃动关闭"));
        ALARM_MAP.put("000AH", new AbstractMap.SimpleEntry<>("断线", "计量线断开，影响电⼦部分记录，阀⻔⾃动关闭"));
        ALARM_MAP.put("000BH", new AbstractMap.SimpleEntry<>("开阀失败", "开启阀⻔失败"));
        ALARM_MAP.put("000CH", new AbstractMap.SimpleEntry<>("关阀失败", "关闭阀⻔失败"));
        ALARM_MAP.put("000DH", new AbstractMap.SimpleEntry<>("存储器异常", "表具内部存储单位异常，⽆法正常记录数据"));
        ALARM_MAP.put("000EH", new AbstractMap.SimpleEntry<>("晶振停振", "影响内部时钟精度"));
        ALARM_MAP.put("000FH", new AbstractMap.SimpleEntry<>("⽋量", "表内剩余⼩于⽋量报警阈值"));
        ALARM_MAP.put("0010H", new AbstractMap.SimpleEntry<>("开盖", "带有开盖报警功能的表具罩壳被打开"));
        ALARM_MAP.put("0011H", new AbstractMap.SimpleEntry<>("透⽀", "表内剩余少于设置的透⽀阈值"));
        ALARM_MAP.put("0012H", new AbstractMap.SimpleEntry<>("零额", "表内剩余⾦额⼩于等于零"));
        ALARM_MAP.put("0013H", new AbstractMap.SimpleEntry<>("⼩流量", "检测到过⼩的⽤⽓流量"));
        ALARM_MAP.put("0014H", new AbstractMap.SimpleEntry<>("温度异常", "流量计内部温度异常"));
        ALARM_MAP.put("0015H", new AbstractMap.SimpleEntry<>("压⼒异常", "流量计内部压⼒异常"));
        ALARM_MAP.put("0016H", new AbstractMap.SimpleEntry<>("计量异常", "计量单元发⽣问题"));
        ALARM_MAP.put("0017H", new AbstractMap.SimpleEntry<>("⽆阀", "表具无阀⻔"));
        ALARM_MAP.put("0018H", new AbstractMap.SimpleEntry<>("阀门异常", "阀⻔发⽣故障"));
        ALARM_MAP.put("1000H", new AbstractMap.SimpleEntry<>("集中器低压", "集中器电源发⽣⽋压或失压"));
        ALARM_MAP.put("1001H", new AbstractMap.SimpleEntry<>("集中器市电掉电", "市电供电的集中器市电突然断开"));
        ALARM_MAP.put("FFFFH", new AbstractMap.SimpleEntry<>("未知事件", "未知事件"));
    }

    public static String getTransId() {
        Random random = new Random();
        return DateTools.getNow("yyyyMMddHHmmss") + (80000000 + random.nextInt(9999999));
    }

    public static String getToken(String transId) {
        return DigestUtils.sha256Hex(key + merchantId + transId);
    }

    public static JSONObject parseArray(JSONArray array) {
        JSONObject result = new JSONObject();
        for (Object item : array) {
            JSONObject itemObj = (JSONObject) item;
            result.put(itemObj.getString("serviceId"), itemObj.getJSONObject("serviceData"));
        }
        return result;
    }

    public static JSONObject getAlarmData(String type) {
        JSONObject result = new JSONObject();
        AbstractMap.SimpleEntry<String, String> entry = ALARM_MAP.get(type);
        if (entry == null) {
            return null;
        }
        result.put(entry.getKey(), entry.getValue());
        return result;
    }
}
