package com.aote.webmeter.module.cangnantcp;

import com.aote.util.other.RestTools;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.util.Arrays;


public class CangNanCommandHelper {

    private static final Logger log = Logger.getLogger(CangNanCommandHelper.class);

    private static final String COMPANY_CODE = "3219";

    /**
     * 流量计地址
     */
    private static final byte ADDR_CODE = (byte) 0x17;

    /**
     * 注册包
     */
    private static final byte REG_MSG = (byte) 0x53;

    /**
     * 心跳包
     */
    private static final byte HEART_BEAT_MSG = (byte) 0xA3;

    /**
     * 充值响应
     */
    private static final byte RECAHRGE_RESPONSE_MSG_1 = (byte) 0x66;

    /**
     * 充值响应
     */
    private static final byte RECAHRGE_RESPONSE_MSG_2 = (byte) 0xA0;

    /**
     * 调价响应
     */
    private static final byte PRICE_ADJUSTMENT_RESPONSE_MSG_1 = (byte) 0x66;

    /**
     * 调价响应
     */
    private static final byte PRICE_ADJUSTMENT_RESPONSE_MSG_2 = (byte) 0xA8;

    /**
     * 关阀响应
     */
    private static final byte CLOSE_VALVE_RESPONSE_MSG_1 = (byte) 0x66;

    /**
     * 关阀响应
     */
    private static final byte CLOSE_VALVE_RESPONSE_MSG_2 = (byte) 0xA7;

    /**
     * 抄表响应
     */
    private static final byte READ_METER_RESPONSE_MSG_1 = (byte) 0x03;

    /**
     * 抄表响应
     */
    private static final byte READ_METER_RESPONSE_MSG_2 = (byte) 0xA0;

    /**
     * @param hexStr
     * @return
     */
    public static int decodeMsgType(String hexStr) {
        try {
            byte[] data = HexUtils.toBytes(hexStr);
            if (data[0] == ADDR_CODE && data[1] == REG_MSG) {
                //注册
                return 11;
            } else if (data[0] == ADDR_CODE && data[1] == HEART_BEAT_MSG) {
                //心跳
                return 12;
            } else if (data[0] == ADDR_CODE && data[1] == RECAHRGE_RESPONSE_MSG_1 && data[3] == RECAHRGE_RESPONSE_MSG_2) {
                //充值响应
                return 21;
            } else if (data[0] == ADDR_CODE && data[1] == CLOSE_VALVE_RESPONSE_MSG_1 && data[3] == CLOSE_VALVE_RESPONSE_MSG_2) {
                //关阀响应
                return 31;
            } else if (data[0] == ADDR_CODE && data[1] == READ_METER_RESPONSE_MSG_1 && data[2] == READ_METER_RESPONSE_MSG_2) {
                //抄表响应
                return 41;
            } else if (data[0] == ADDR_CODE && data[1] == PRICE_ADJUSTMENT_RESPONSE_MSG_1 && data[3] == PRICE_ADJUSTMENT_RESPONSE_MSG_2) {
                //调价响应
                return 51;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return -999;
        }
        return -1;
    }

    /**
     * 生成充值指令
     *
     * @param meterId
     * @param cardId
     * @param gasValue
     * @param times
     * @return
     */
    public static String createRechargeCommand(String meterId, String cardId, BigDecimal gasValue, BigDecimal times) {
        log.debug("开始构建【充值】指令......");
        byte[] command = new byte[48];
        //构造充值包
        byte[] data = new byte[46];
        byte[] crc;

        //流量计地址
        data[0] = 0x17;
        //功能码
        data[1] = 0x66;
        //data[2]，版本，默认为0
        data[2] = 0;
        //子功能
        data[3] = (byte) 0xA0;
        //长度
        data[4] = 0x29;
        //集中器表号 10(BCD) 不足的前面补0，如00 00 00 00 00 00 00 00 00 01
        meterId = String.format("%020d", Long.parseLong(meterId));
        byte[] dtuId = HexUtils.str2Bcd(meterId);
        System.arraycopy(dtuId, 0, data, 5, 10); //14
        //流量计编号 6(BCD) 即卡号，不足的前面补0，如00 00 00 00 00 01,
        cardId = String.format("%012d", Long.parseLong(cardId));
        byte[] cId = HexUtils.str2Bcd(cardId);
        System.arraycopy(cId, 0, data, 15, 6);  //20
        //公司代号 2(BCD) 如  3411  3219
        byte[] companyCode = HexUtils.str2Bcd(COMPANY_CODE);
        System.arraycopy(companyCode, 0, data, 21, 2);
        //备用命令 5(Hex) 后期扩展 27
        //购气次数 2(Hex) 如 02H，即第 2 次购气
        byte[] timesArr = shortToByte2(times.shortValue());
        System.arraycopy(timesArr, 0, data, 28, 2);
        //本次输入量 4(Hex) 整型，金额单位（分） ，如 00 01 86 A0，100000 分
        //byte[] gasAmountArr = {(byte) 0x00, (byte) 0x00, (byte) 0x27, (byte) 0x10};
        byte[] gasAmountArr = intToByte4(gasValue.multiply(new BigDecimal("100")).intValue());
        System.arraycopy(gasAmountArr, 0, data, 30, 4); //33
        System.out.println(HexUtils.encodeHexStr(data));
        //计算 MAC 常数 8(Hex) MAC 计算时， 使用的常量， 如 55 86 27 61 68 88 25 45
        //4427567442684234
        byte[] macSalt = {44, 27, 56, 74, 42, 68, 42, 34};
        System.arraycopy(macSalt, 0, data, 34, 8);  //41
        //MAC 4(Hex) MAC 计算结果，如 881C08A0  C210C75F 21A6AEA9  7C02BB1C 07D411EE
        byte[] calculateValue = new byte[29];
        System.arraycopy(data, 5, calculateValue, 0, 29);  //45
        String macStr = calculateMac(HexUtils.encodeHexStr(calculateValue));
        //byte[] mac = {(byte) 0x96, (byte) 0xEC, (byte) 0xF7, (byte) 0x07};
        byte[] mac = HexUtils.str2Bcd(macStr);
        //28A53338  96ECF707
        System.arraycopy(mac, 0, data, 42, 4);  //45
        // 0 - 45
        //CRC 检验 2(Hex)
        crc = HexUtils.toBytes(CRCUtils.getCrc(data));

        System.arraycopy(data, 0, command, 0, 46);
        System.arraycopy(crc, 0, command, 46, 2);
        log.debug("最终生成【充值】指令：" + HexUtils.encodeHexStr(command));
        return HexUtils.encodeHexStr(command);
    }

    /**
     * 生成调价指令
     *
     * @param meterId
     * @param cardId
     * @param stair1Price
     * @param stair1Amount
     * @param stair2Price
     * @param stair2Amount
     * @param stair3Price
     * @param stair3Amount
     * @param cycleStartTime
     * @param stairPriceCycleTime
     * @param priceVersion
     * @return
     */
    public static String createPriceAdjustCommand(String meterId, String cardId,
                                                  BigDecimal stair1Price, BigDecimal stair1Amount,
                                                  BigDecimal stair2Price, BigDecimal stair2Amount,
                                                  BigDecimal stair3Price, BigDecimal stair3Amount, String cycleStartTime, String stairPriceCycleTime, int priceVersion) {
        log.debug("开始构建【调价】指令......");
        byte[] command = new byte[85];
        //构造调价包
        byte[] data = new byte[83];
        byte[] crc;

        //流量计地址
        data[0] = 0x17;
        //功能码
        data[1] = 0x66;
        //data[2]，版本，默认为0
        data[2] = 0;
        //子功能
        data[3] = (byte) 0xA8;
        //长度
        data[4] = 0x4E;
        //集中器表号 10(BCD) 不足的前面补0，如00 00 00 00 00 00 00 00 00 01
        meterId = String.format("%020d", Long.parseLong(meterId));
        byte[] dtuId = HexUtils.str2Bcd(meterId);
        System.arraycopy(dtuId, 0, data, 5, 10); //14
        //流量计编号 6(BCD) 即卡号，不足的前面补0，如00 00 00 00 00 01,
        cardId = String.format("%012d", Long.parseLong(cardId));
        byte[] cId = HexUtils.str2Bcd(cardId);
        System.arraycopy(cId, 0, data, 15, 6);  //20
        //公司代号 2(BCD) 如  3411  3219
        byte[] companyCode = HexUtils.str2Bcd(COMPANY_CODE);
        System.arraycopy(companyCode, 0, data, 21, 2);
        //备用命令 5(Hex) 后期扩展 27
        //常规燃气价格，相当于第一阶梯价格，单位：分 2(Hex) 如 如价格单位为分，015EH，即 3.5元
//        byte[] timesArr = shortToByte2(times.shortValue());
//        System.arraycopy(timesArr, 0, data, 28, 2);
        return null;
    }

    /**
     * 生成阀门控制指令
     *
     * @param meterId
     * @param cardId
     * @param valveCommand 0：解除开阀禁止状态，1：关阀且禁止开阀
     * @return
     */
    public static String createValveCommand(String meterId, String cardId, BigDecimal valveCommand) {
        log.debug("开始构建【阀控】指令......");
        byte[] command = new byte[43];
        //构造充值包
        byte[] data = new byte[41];
        byte[] crc;

        //流量计地址
        data[0] = 0x17;
        //功能码
        data[1] = 0x66;
        //data[2]，版本，默认为0
        data[2] = 0;
        //子功能
        data[3] = (byte) 0xA7;
        //长度
        data[4] = 0x24;
        //集中器表号 10(BCD) 不足的前面补0，如00 00 00 00 00 00 00 00 00 01
        meterId = String.format("%020d", Long.parseLong(meterId));
        byte[] dtuId = HexUtils.str2Bcd(meterId);
        System.arraycopy(dtuId, 0, data, 5, 10); //14
        //流量计编号 6(BCD) 即卡号，不足的前面补0，如00 00 00 00 00 01,
        cardId = String.format("%012d", Long.parseLong(cardId));
        byte[] cId = HexUtils.str2Bcd(cardId);
        System.arraycopy(cId, 0, data, 15, 6);  //20
        //公司代号 2(BCD) 如  3411  3219
        byte[] companyCode = HexUtils.str2Bcd(COMPANY_CODE);
        System.arraycopy(companyCode, 0, data, 21, 2);
        //备用命令 5(Hex) 后期扩展 27
        //阀控命令 1(Hex) 00：解除开阀禁止状态，01：关阀且禁止开阀
        byte[] valveCmd = valveCommand.shortValue() == 1 ? new byte[]{0x01} : new byte[]{0x00};
        System.arraycopy(valveCmd, 0, data, 28, 1);
        //计算 MAC 常数 8(Hex) MAC 计算时， 使用的常量， 如 55 86 27 61 68 88 25 45
        //4427567442684234
        byte[] macSalt = {44, 27, 56, 74, 42, 68, 42, 34};
        System.arraycopy(macSalt, 0, data, 29, 8);  //41
        //MAC 4(Hex) MAC 计算结果，如 07D411EE
        byte[] calculateValue = new byte[24];
        System.arraycopy(data, 5, calculateValue, 0, 24);  //45
        String macStr = calculateMac(HexUtils.encodeHexStr(calculateValue));
        //byte[] mac = {(byte) 0x96, (byte) 0xEC, (byte) 0xF7, (byte) 0x07};
        byte[] mac = HexUtils.str2Bcd(macStr);
        //28A53338  96ECF707
        System.arraycopy(mac, 0, data, 37, 4);  //45
        // 0 - 45
        //CRC 检验 2(Hex)
        crc = HexUtils.toBytes(CRCUtils.getCrc(data));

        System.arraycopy(data, 0, command, 0, 41);
        System.arraycopy(crc, 0, command, 41, 2);
        log.debug("最终生成【阀控】指令：" + HexUtils.encodeHexStr(command));
        return HexUtils.encodeHexStr(command);
    }

    /**
     * 生成抄表指令
     *
     * @return
     */
    public static String createMeterReadCommand() {
        byte[] command = {0x17, 0x03, 0x02, 0x50, 0x00, 0x50, 0x46, (byte) 0xA9};
        return HexUtils.encodeHexStr(command);
    }

    public static JSONObject decodeMsg(String msg) {
        int msgType = decodeMsgType(msg);
        JSONObject obj = new JSONObject();
        if (msgType == 11 || msgType == 12) {
            //注册包或者心跳包  17A3197F 31323334353637383930310 000000000 17007F7F7F030002F749
            String meterId = HexUtils.asciiHexStr2Str(msg.substring(8, 8 + 11 * 2));
            obj.put("meterId", meterId);
        }
        return obj;
    }

    public static JSONObject decodeAckMsg(String msg) {
        log.debug("开始解析【表端响应】指令......");
        int msgType = decodeMsgType(msg);
        JSONObject obj = new JSONObject();
        if (msgType == 21 || msgType == 31) {
            //充值响应or阀控响应 176600A021000502 00000000012345678901001122334455 09 3411 0000000000
            //0000000A 0001 7955
            String meterId = msg.substring(25, 36);
            String cardId = msg.substring(38, 48);
            int responseCode = Integer.parseInt(msg.substring(48, 50), 16);
            int surplusGas = Integer.parseInt(msg.substring(64, 72), 16);
            int meterTimes = Integer.parseInt(msg.substring(72, 76), 16);
            obj.put("meterId", meterId);
            obj.put("cardId", cardId);
            obj.put("responseCode", responseCode);
            obj.put("surplusGas", surplusGas);
            obj.put("meterTimes", meterTimes);
        } else if (msgType == 41) {
            //解析抄表数据
            processMeterReadingData(msg);

            System.out.println();
        }
        log.debug("解析结果: " + obj.toString());
        return obj;
    }

    private static JSONObject processMeterReadingData(String msg) {
        msg = msg.substring(6);
        //表内剩余金额8
        String sumLeftVolStr = msg.substring(0, 16);
        //表内累计用气量8
        String sumUsedVolStr = msg.substring(16, 32);
        //用户卡累计输入量8
        String sumBuyedVolStr = msg.substring(100, 116);
        //状态字2
        String stateStr = msg.substring(116, 120);
        //报警字2
        String alarmStr = msg.substring(120, 124);
        //表内时间6
        String meterTimeStr = msg.substring(124, 136);
        //远传表位置号8(卡号， 十位)
        String cardIdStr = msg.substring(152, 168);
        //累计购气次数2
        String sumBuyedCountStr = msg.substring(168, 172);
        //累计用量8
        String sumUsedVolStr2 = msg.substring(172, 188);
        //上次购买量4
        String lastBuyedVolStr = msg.substring(188, 196);
        //上次充值时间6
        String lastBuyedTimeStr = msg.substring(196, 208);
        //阀门使能1 0（正常）1（禁止开阀）
        String valveStateStr = msg.substring(252, 254);

        //解析状态字和报警字00000011
        String overdraftState = byteToBitString(new Byte(stateStr.substring(2))).substring(6, 7);
        String valveState = byteToBitString(new Byte(stateStr.substring(2))).substring(7, 7);

        return null;
    }

    public static String byteToBitString(byte b) {
        return ""
                + (byte) ((b >> 7) & 0x1) + (byte) ((b >> 6) & 0x1)
                + (byte) ((b >> 5) & 0x1) + (byte) ((b >> 4) & 0x1)
                + (byte) ((b >> 3) & 0x1) + (byte) ((b >> 2) & 0x1)
                + (byte) ((b >> 1) & 0x1) + (byte) ((b >> 0) & 0x1);
    }

    /**
     * 调用后台卡服务计算mac值
     *
     * @param value
     * @return
     */
    private static String calculateMac(String value) {
        //接收到的数据是带""号的，需要去掉
        //"6AFF5F8A"
        return RestTools.post("", value).substring(1, 9);
    }

    /**
     * short整数转换为2字节的byte数组
     *
     * @param s short整数
     * @return byte数组
     */
    private static byte[] shortToByte2(int s) {
        byte[] targets = new byte[2];
        targets[0] = (byte) (s >> 8 & 0xFF);
        targets[1] = (byte) (s & 0xFF);
        return targets;
    }

    private static byte[] intToByte4(int i) {
        byte[] targets = new byte[4];
        targets[3] = (byte) (i & 0xFF);
        targets[2] = (byte) (i >> 8 & 0xFF);
        targets[1] = (byte) (i >> 16 & 0xFF);
        targets[0] = (byte) (i >> 24 & 0xFF);
        return targets;
    }

    private static byte[] intToByte2(int i) {
        byte[] targets = new byte[2];
        targets[1] = (byte) (i & 0xFF);
        targets[0] = (byte) (i >> 8 & 0xFF);
        return targets;
    }

    public static void main(String[] args) {
//        String meterId = "1122334455";
//        meterId = String.format("%012d", Long.parseLong(meterId));
//        System.out.println(meterId + " : " + meterId.length());
//        int times = 169;
//        System.out.println(Arrays.toString(shortToByte2(times)));
//        System.out.println(Long.parseLong("FFAACCBB"));
        //String rechargeCommand = createRechargeCommand("12345678901", "1122334455", new BigDecimal("20"), new BigDecimal("4"));
        //System.out.println(rechargeCommand);
        //
//        JSONObject jsonObject = decodeMsg("17A3197F3132333435363738393031000000000017007F7F7F030002F749");
//        JSONObject jsonObject2 = decodeAckMsg("176600A021000502000000000123456789010011223344550934110000000000000186A000A17955");
//        JSONObject jsonObject3 = decodeMsg("176600A71C000503000000000000000000010000000000010134110000000000012CA0");
//
//        System.out.println(jsonObject);
//        System.out.println(jsonObject2);
//        System.out.println(jsonObject3);

//        int i = new BigDecimal("20").multiply(new BigDecimal("100")).intValue();
//        System.out.println(i);
//
//        decodeAckMsg("1703A04065800000000000000000000000000000010000000000000000000000000000000000000000000000004170000042D200004065800000000000000325F0190527145243000000000000000000000011223344550007000000000000000041A000001905211304290000000000000000000000000000000020190106330066000000000000000000000000000000000000000000000000000000000000000001E9");
//
//        System.out.println(byteToBitString(new Byte("0001".substring(2))).substring(6, 7));
//        System.out.println(byteToBitString(new Byte("0001".substring(2))).substring(7));
        System.out.println(Arrays.toString(intToByte2(350)));
    }
}
