package com.aote.webmeter.module.CangNanYGSystem;

import com.af.plugins.JsonTools;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class Tool {

    static {
        System.setProperty("jna.encoding", "GBK");
    }

    private final Logger log = Logger.getLogger(Tool.class);

    public static String genTradeNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String s = sdf.format(new Date());

        for (int i = 0; i < 3; i++) {
            Random random = new Random();
            s += random.nextInt(9);
        }
        return "CNMCSPKYNYN" + s;
    }


    private CNICCard cnicCard = null;

    public Tool() {
        try {
            this.cnicCard = (CNICCard)
                    Native.loadLibrary(
                            "D:\\TripleMACAndDES_DLL\\CNICCard",
                            CNICCard.class);
        } catch (Throwable e) {
            log.error("加载苍南物联网表模块时，动态库加载失败，联系管理员或者奥枫软件技术人员排查处理。");
        }
    }

    /**
     * 生成16位随机加密Key
     *
     * @return 16位随机加密Key
     */
    public String randomStr() {
        Random r = new Random(1);
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < 16; i++) {
            int ran1 = r.nextInt(10);
            ret.append(ran1);
        }
        return ret.toString();
    }

    /**
     * 解密响应数据
     *
     * @param data 解密请求pluging4.0封装的响应
     * @return 解密后的数据
     */
    public JSONObject decryptResponse(String data) {
        JSONObject response = null;
        try {
            response = JsonTools.convertToJson(data);
            JSONObject ret = new JSONObject();
            if (response.getInt("code") != 500) {
                String headerStr = response.getString("header");
                JSONObject header = JsonTools.convertToJson(StringEscapeUtils.unescapeJava(headerStr));
                log.info(header.toString());
                return decrypt(header, response.getString("content"));
            }
            return null;
        } catch (Throwable e) {
            log.warn("苍南解密响应出现未知错误");
            log.warn(response.toString());
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 解密密文
     *
     * @param header     头
     * @param cipherText 密文
     * @return 解密后的数据
     */
    public JSONObject decrypt(JSONObject header, String cipherText) {
        try {
            String disperseKey = header.getString("DisperseKey");
            String macValue = header.getString("MacValue");
            //mac校验
            if (TripleMAC(macValue, disperseKey) != null) {
                String temp = TripleDESDecrypt(cipherText, disperseKey);
                log.debug(temp);
                if (temp != null) {
                    return JsonTools.convertToJson(temp);
                }
                log.warn("解密失败");
                return null;
            } else {
                log.warn("mac 校验未通过，返回null");
                return null;
            }
        } catch (Throwable e) {
            e.printStackTrace();
            log.warn("苍南动态库解密出现异常，请及时处理");
            return null;
        }
    }


    public String TripleMAC(String inputData, String randomStr) {
        if (inputData == null || randomStr == null) {
            log.warn("分散因子或秘钥长度不正确");
            return null;
        }
        Pointer pointer = new Memory(1024);
        int s = cnicCard.TripleMAC(
                inputData,
                randomStr,
                pointer
        );
        if (s == 0) {
            return pointer.getString(0);
        } else if (s == -1) {
            log.warn("动态库未注册，请及时联系苍南仪表厂进行注册。");
            return null;
        } else if (s == -2) {
            log.warn("分散因子或秘钥长度不正确");
            return null;
        } else {
            log.warn("动态库计算MAC值出现一个预期之外的异常");
            log.warn("加密内容：" + inputData);
            log.warn("加密因子：" + randomStr);
            log.warn("加密结果：" + s);
            return null;
        }
    }

    public String TripleDESEncrypt(String inputData, String randomStr) {
        if (inputData == null || randomStr == null) {
            log.warn("分散因子或秘钥长度不正确");
            return null;
        }
        int s = -1;
        try {
            Pointer pointer = new Memory(1024);
            s = cnicCard.TripleDESEncrypt(
                    inputData,
                    randomStr,
                    pointer
            );
            if (s == 0) {
                return pointer.getString(0);
            } else if (s == -1) {
                log.warn("动态库未注册，请及时联系苍南仪表厂进行注册。");
                return null;
            } else if (s == -2) {
                log.warn("分散因子或秘钥长度不正确");
                return null;
            } else {
                log.warn("动态库加密出现一个预期之外的异常");
                log.warn("加密内容：" + inputData);
                log.warn("加密因子：" + randomStr);
                log.warn("加密结果：" + s);
                return null;
            }
        } catch (Throwable e) {
            log.warn("动态库加密出现异常");
            log.warn("加密内容：" + inputData);
            log.warn("加密因子：" + randomStr);
            log.warn("加密结果：" + s);
            e.printStackTrace();
            return null;
        }
    }

    public String TripleDESDecrypt(String inputData, String randomStr) {
        if (inputData == null || randomStr == null) {
            log.warn("分散因子或秘钥长度不正确");
            return null;
        }
        int s = -2;
        try {
            Pointer pointer = new Memory(1024);
            s = cnicCard.TripleDESDecrypt(
                    inputData,
                    randomStr,
                    pointer
            );
            if (s == 0) {
                return pointer.getString(0);
            } else if (s == -1) {
                log.warn("动态库未注册，请及时联系苍南仪表厂进行注册。");
                return null;
            } else if (s == -2) {
                log.warn("分散因子或秘钥长度不正确");
                return null;
            } else {
                log.warn("动态库加密出现一个预期之外的异常");
                log.warn("加密内容：" + inputData);
                log.warn("加密因子：" + randomStr);
                log.warn("加密结果：" + s);
                return null;
            }
        } catch (Throwable e) {

            log.warn("动态库加密出现异常");
            log.warn("加密内容：" + inputData);
            log.warn("加密因子：" + randomStr);
            log.warn("加密结果：" + s);
            e.printStackTrace();
            return null;
        }
    }

    interface CNICCard extends Library {
        public int TripleMAC(String inputData, String randomStr, Pointer packet);

        public int TripleDESEncrypt(String inputData, String randomStr, Pointer packet);

        public int TripleDESDecrypt(String inputData, String randomStr, Pointer packet);


    }

}
