package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 物联网表服务 移动IOT平台接口地址
 *
 * @author Mr.river
 */
public enum OnenetApiEnum {

    //BASE_URL
    BASE_URL("http://api.heclouds.com"),
    //BASE_PORT
    BASE_PORT("80"),
    //设备接口
    DEVICE_URL("http://" + BASE_URL.value + ":" + BASE_PORT.value + "/devices"),
    //资源接口
    RESOURCE_URL("http://" + BASE_URL.value + ":" + BASE_PORT.value + "/nbiot"),
    //命令接口
    COMMAND_URL("http://" + BASE_URL.value + ":" + BASE_PORT.value + "/nbiot/execute"),
    //订阅接口
    SUBSCRIPTIONS_URL("http://" + BASE_URL.value + ":" + BASE_PORT.value + "/nbiot/observe");

    private final String value;

    OnenetApiEnum(String value) {
        this.value = value;
    }

    public static OnenetApiEnum toType(String value) {
        return Stream.of(OnenetApiEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
