-- 公共SQL：查询待开户的表具信息（银光系统用)
-- 必选参数
-- f_meter_brand：气表品牌名称，如宇迪NB物联网表，伦力NB物联网表等

SELECT t_userfiles.id                      f_user_id,
       t_userfiles.f_userid                f_userinfo_id,
       t_userfiles.f_meternumber,
       t_userfiles.f_aliasname             f_meter_brand,
       t_userinfo.f_phone,
       t_userinfo.f_username,
       isnull(t_userinfo.f_address, '')    f_address,
       t_userinfo.f_price_id,
       t_userinfo.f_stairtype              f_price_type,
       t_userinfo.f_usertype,
       isnull(t_userinfo.f_stairmonths, 1) f_stairmonths,
       t_userinfo.f_stair1amount,
       t_userinfo.f_stair1price,
       t_userinfo.f_stair2amount,
       t_userinfo.f_stair2price,
       t_userinfo.f_stair3amount,
       t_userinfo.f_stair3price,
       t_userfiles.f_display_type,
       t_userfiles.f_param_list,
       t_userfiles.f_cardid
FROM t_userfiles
         LEFT JOIN t_userinfo ON t_userinfo.f_userid = t_userfiles.f_userinfoid
WHERE t_userfiles.f_aliasname = '{f_meter_brand}'
  AND t_userfiles.f_userstate = '正常'
  AND t_userinfo.f_price_id is not null
  AND t_userfiles.f_times > 0
  AND (t_userfiles.f_sendsuccess <> '成功' OR t_userfiles.f_sendsuccess IS NULL)
