SELECT 
	s.f_sendsuccess,
	s.id sellid,
	s.f_userinfo_id,
	s.f_user_id,
	b.f_manufacturers,
	b.f_alias,
	u.version,
	i.f_filiale,
	i.f_outlets,
	u.f_meternumber f_meternumber,
	'远程购气' CmdName,
	'04' CmdType,
      '0' CmdState
      ,s.f_delivery_date CmdSendTime
      ,u.f_meternumber DevCode
      ,'35' DevType
      ,m.f_meter_style MeterType
      ,'GPRS' CommType
      ,(case when i.f_user_type='民用' then '01'
			 else '02' end) UserType
      ,cast(u.f_times as varchar) +'|'+cast(s.f_collection as varchar)+'|'+right(u.f_meternumber,10)+'|0517' CmdParm
FROM
	t_sellinggas s
LEFT JOIN t_userfiles u ON u.f_userinfo_id = s.f_userinfo_id
LEFT JOIN t_userinfo i ON u.f_userinfo_id = i.f_userinfo_id
LEFT JOIN (select * from t_stairprice where    (getdate()>=f_perform_date and getdate()<=f_end_date)) j ON i.f_price_id = j.f_price_id 
LEFT JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
LEFT JOIN t_gasmodel m ON u.f_gasmodel_id = m.id
WHERE
	(
		s.f_sendsuccess <> '成功'
		OR s.f_sendsuccess IS NULL
	)
AND s.f_charge_type!='自动下账'
AND s.f_charge_type!='用户退费'
AND s.f_charge_state = '有效'
AND DATEDIFF(
	DAY,
	s.f_delivery_date,
	GETDATE ()
) <= 7
AND DATEDIFF(
	DAY,
	s.f_delivery_date,
	GETDATE ()
) >= 0
AND u.f_table_state != '停用'
AND i.f_userinfo_id > 0
AND m.id > 0
AND j.id > 0
AND j.f_state = '有效'
AND b.id > 0
and b.f_meter_type='物联网表'
and b.f_alias='ShanCheng'
AND s.id > 0
ORDER BY
	sellid