select
	CASE {groupname} when {groupname} THEN substr({groupname},{starIndex},{endIndex}) END dates,
  sum(gas) gas
from (
	SELECT
	 TO_CHAR (f_hand_date,'YYYY') year,
	 TO_CHAR (f_hand_date,'YYYY-MM') month,
	 TO_CHAR (f_hand_date,'YYYY-MM-DD') day,
	 sum(f_tablebase-f_last_tablebase) as gas
	FROM T_METEREAD
	where f_hand_date >= {startDate}
	and f_hand_date <= {endDate}
  and f_meternumber = '{f_meternumber}'
	group by
		TO_CHAR (f_hand_date,'YYYY'),
		TO_CHAR (f_hand_date,'YYYY-MM'),
		TO_CHAR (f_hand_date,'YYYY-MM-DD')
  union ALL
	select
		TO_CHAR (DAY_DATE,'YYYY') year,
		TO_CHAR (DAY_DATE,'YYYY-MM') month,
		TO_CHAR (DAY_DATE,'YYYY-MM-DD') day,
    0 gas
  from(
		SELECT {startDate} + ROWNUM - 1 DAY_DATE
		FROM DUAL
		CONNECT BY ROWNUM <= {endDate} - {startDate}+ 1
  ) d
) s
group by {groupname}
order by {groupname}