select
  ts.id,
  convert(varchar ,tf.f_user_id) f_user_id,
  tf.f_sync_user_id,
  ts.f_collection,
  ts.f_userinfo_id,
  tf.f_meternumber,
  ts.f_outlets,
  ts.f_filiale,
  ts.f_orgstr,
  ts.f_times
from t_sellinggas ts
       left join t_userinfo tu on ts.f_userinfo_id = tu.f_userinfo_id
       left join t_userfiles tf on ts.f_user_id = tf.f_user_id
       left join t_gasbrand tg on tf.f_gasbrand_id = tg.id
where tg.f_alias = '{f_meter_brand}'
  AND ts.f_meter_type = '物联网表'
  and tf.f_times > 1
  and tu.f_user_state <> '销户'
  and ts.f_charge_type <> '自动下账'
  and (ts.f_sendsuccess is null or ts.f_sendsuccess <> '成功')
  and ts.f_charge_state = '有效'
  and tf.F_SYNC_USER_ID is not null
  and Datediff(minute ,ts.f_delivery_date,getDate())>5
order by ts.id asc