SELECT t_pricechange.id id,
       s.id             f_new_price_id,
       u.f_meternumber,
       u.f_user_id      userId
FROM t_pricechange
         INNER JOIN t_userfiles u ON u.f_userinfo_id = t_pricechange.f_userinfo_id
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
         LEFT JOIN t_stairprice s ON s.id = t_pricechange.f_newprice_id and u.f_filialeids = s.f_filialeids
WHERE s.f_state = '有效'
  AND s.{stairPriceSync} = '成功'
  AND getdate() >= s.f_perform_date
  and getdate() <= s.f_end_date
  AND (t_pricechange.F_SENDSUCCESS <> '成功' OR t_pricechange.F_SENDSUCCESS IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND t_pricechange.f_userinfo_id is not null
  AND t_pricechange.id =
      (SELECT MAX(ID) FROM t_pricechange c where c.f_userinfo_id = t_pricechange.f_userinfo_id)
  AND u.f_table_state = '正常'
ORDER BY t_pricechange.id DESC
