SELECT t_pricechange.id                               id,
       s.id                                           stairId,
       s.f_version                                    priceVersion,
       isnull(s.f_stair_start_date, s.f_perform_date) start_date,
       s.f_perform_date                               f_perform_date,
       isnull(s.f_stairmonths, 1)                     f_stairmonths,
       u.f_meternumber,
       u.f_user_id                                    userId
FROM t_pricechange
         LEFT JOIN t_stairprice s ON s.id = t_pricechange.f_newprice_id
         INNER JOIN t_userfiles u ON u.f_price_id = s.f_price_id and u.f_filialeids = s.f_filialeids
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
WHERE s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  and getdate() <= s.f_end_date
  AND (t_pricechange.F_SENDSUCCESS <> '成功' OR t_pricechange.F_SENDSUCCESS IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND t_pricechange.f_userinfo_id is null
  AND u.f_input_date < t_pricechange.f_operate_date
  AND u.f_table_state = '正常'
