SELECT u.f_user_id,
       u.f_userinfo_id,
       u.f_meternumber,
       b.f_meter_brand,
       o.f_user_name,
       o.f_user_phone,
       s.id                       f_stairprice_id,
       isnull(s.f_stairmonths, 1) f_stairmonths,
       u.f_show_way               f_display_type
FROM t_userfiles u
         LEFT JOIN t_userinfo o ON o.f_userinfo_id = u.f_userinfo_id
         LEFT JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
         LEFT JOIN t_stairprice s ON s.f_price_id = u.f_price_id and u.f_orgid = s.f_orgid
WHERE (
        u.f_sendsuccess <> '成功'
        OR u.f_sendsuccess IS NULL
    )
  AND o.f_user_state = '正常'
  AND b.f_alias = '{f_meter_brand}'
  AND u.f_table_state = '正常'
  AND s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  and getdate() <= s.f_end_date
