SELECT u.f_user_id,
       u.f_userinfo_id,
	   u.f_userfiles_id,
       u.f_meternumber,
       u.f_initial_base,
       b.f_meter_brand,
       o.f_user_name,
       o.f_user_phone,
       u.f_user_type,
       s.id                       f_stairprice_id,
       s.f_version                price_version,
       isnull(s.f_stairmonths, 1) f_stairmonths,
       b.f_calculation            settle_type,
       m.f_meter_style,
       isnull(s.f_stair_start_date,s.f_perform_date)       start_date,
       s.f_perform_date           f_perform_date,
	   u.f_filialeid
FROM t_userfiles u
         LEFT JOIN t_userinfo o ON o.f_userinfo_id = u.f_userinfo_id
         LEFT JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
         LEFT JOIN t_gasmodel m ON u.f_gasmodel_id = m.id
         LEFT JOIN t_stairprice s ON s.f_price_id = u.f_price_id and u.f_filialeid = s.f_filialeid
WHERE (
        u.f_sendsuccess <> '成功'
        OR u.f_sendsuccess IS NULL
    )
  AND o.f_user_state = '正常'
  AND b.f_alias = '{f_meter_brand}'
  AND u.f_table_state = '正常'
  AND s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  AND getdate() <= s.f_end_date
