SELECT t_pricechange.id,
       u.f_user_id,
       u.f_price_id,
       s.f_price_id               f_stairprice_id,
       isnull(s.f_stairmonths, 1) f_stairmonths,
       os.f_price_id              f_old_stairprice_id,
       u.f_meternumber
FROM t_pricechange
         LEFT JOIN t_stairprice s ON s.id = t_pricechange.f_newprice_id
         LEFT JOIN t_stairprice os ON os.id = t_pricechange.f_oldprice_id
         INNER JOIN t_userfiles u ON u.f_price_id = s.f_price_id and u.f_orgid = s.f_orgid
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
WHERE s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  and getdate() <= s.f_end_date
  AND s.f_sync_sendsuccess = '成功'
  AND (t_pricechange.F_SENDSUCCESS <> '成功' OR t_pricechange.F_SENDSUCCESS IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND t_pricechange.f_userinfo_id is null
  AND u.f_input_date < t_pricechange.f_operate_date
