SELECT t_pricechange.id,
       u.f_user_id,
       u.f_userinfo_id,
       u.f_meternumber,
       u.f_initial_base,
       g.f_meter_brand,
       s.id                       f_stairprice_id,
       s.f_price_name,
       m.f_coding                 f_coding,
       isnull(s.f_stairmonths, 1) f_stairmonths,
       isnull(s.f_stair_start_date,s.f_perform_date)       start_date,
       t_pricechange.f_oldprice_id f_old_stairprice_id
FROM t_pricechange
         LEFT JOIN t_stairprice s ON s.id = t_pricechange.f_newprice_id
         INNER JOIN t_userfiles u ON u.f_price_id = s.f_price_id and u.f_orgid = s.f_orgid
         LEFT JOIN t_gasmodel m on u.f_gasmodel_id = m.id
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
WHERE s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  and getdate() <= s.f_end_date
  AND (t_pricechange.F_SENDSUCCESS <> '成功' OR t_pricechange.F_SENDSUCCESS IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND t_pricechange.f_userinfo_id is null
  AND u.f_input_date < t_pricechange.f_operate_date
