SELECT s.id,
       sp.id                                                            f_stairprice_id,
       s.f_preamount,
       s.f_pregas,
       s.f_collection,
       u.f_meternumber,
       s.f_times,
       u.f_total_fee,
       u.f_user_id,
       u.f_show_way                                                     f_display_type,
       sp.f_stairmonths,
       substring(CONVERT(varchar(100), F_PERFORM_DATE, 10), 0, 6) as start_date
FROM t_sellinggas s
         LEFT JOIN t_userfiles u ON u.f_user_id = s.f_user_id
         LEFT JOIN t_stairprice sp ON sp.f_price_id = u.f_price_id and u.f_filialeids = sp.f_filialeids
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
WHERE s.f_charge_state = '有效'
  AND (s.f_sendsuccess <> '成功' OR s.f_sendsuccess IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND s.f_charge_type IN ('物联网收费', '退费')
  AND sp.f_state = '有效'
  AND getdate() >= sp.f_perform_date
  and getdate() <= sp.f_end_date
ORDER BY s.f_times
