select
    t_sellinggas.id,
    t_gasbrand.f_alias,
    t_meterinfo.f_device_id,
    t_sellinggas.f_collection,
    t_sellinggas.f_user_id,
    t_sellinggas.f_userinfo_id,
    t_userfiles.f_filialeid,
    t_userfiles.f_orgid,
    t_userfiles.f_meternumber,
    t_userfiles.f_depid,
    t_sellinggas.f_meter_style,
    t_sellinggas.f_times,
    CONVERT(varchar(100), t_sellinggas.f_operate_date, 20) f_delivery_date
from t_sellinggas
left join t_gasbrand on t_gasbrand.f_meter_brand = t_sellinggas.f_meter_brand
left join t_meterinfo on t_meterinfo.f_meternumber = t_sellinggas.f_meternumber
left join t_userfiles on t_userfiles.f_userfiles_id = t_sellinggas.f_userfiles_id
where t_gasbrand.f_alias = '{f_meter_brand}'
and t_sellinggas.f_sendsuccess is null
and t_sellinggas.f_state = '有效'
and t_userfiles.f_table_state <> '停用'
and t_userfiles.f_table_state <> '换表'
and t_meterinfo.f_device_id is not null
and t_userfiles.f_sendsuccess = '成功'
order by id
