SELECT t_pricechange.id           pricechange_id,
       s.id                       price_id,
       s.f_gasproperties          price_type,
       u.f_user_id                customer_code,
       isnull(s.f_stairmonths, 1) cycle,
       s.f_perform_date           pricedate,
       s.f_stair_start_date       cycledate,
       t_pricechange.f_operator   operator,
       u.f_filialeids             filialeids,
       u.f_user_id                user_id,
       s.f_version                version
FROM t_pricechange
         LEFT JOIN t_stairprice s ON s.id = t_pricechange.f_newprice_id
         INNER JOIN t_userfiles u ON u.f_price_id = s.f_price_id and u.f_filialeids = s.f_filialeids
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
WHERE s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  and getdate() <= s.f_end_date
  AND (t_pricechange.F_SENDSUCCESS <> '成功' OR t_pricechange.F_SENDSUCCESS IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND t_pricechange.f_userinfo_id is null
  AND u.f_input_date < t_pricechange.f_operate_date
